package jp.gr.java_conf.ccs2.tool.mkrelax.relaxer;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RelaxerOptions</b> is generated by Relaxer based on relaxerOptions.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="relaxerOptions">
 *   <tag/>
 *   <sequence>
 *     <ref label="switch" occurs="*"/>
 *     <ref label="option" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="relaxerOptions"&gt;
 *   &lt;tag/&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="switch" occurs="*"/&gt;
 *     &lt;ref label="option" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxerOptions.rlx 1.0 (Sun Oct 07 01:23:03 JST 2001)
 * @author  Relaxer 0.14.2 (http://www.relaxer.org)
 */
public class RelaxerOptions implements java.io.Serializable {
    // List<Switch>
    private java.util.List switch_ = new java.util.ArrayList();
    // List<Option>
    private java.util.List option_ = new java.util.ArrayList();

    /**
     * Creates a <code>RelaxerOptions</code>.
     *
     */
    public RelaxerOptions() {
    }

    /**
     * Creates a <code>RelaxerOptions</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RelaxerOptions(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RelaxerOptions</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RelaxerOptions(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RelaxerOptions</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RelaxerOptions(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RelaxerOptions</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RelaxerOptions(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RelaxerOptions</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RelaxerOptions(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RelaxerOptions</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RelaxerOptions(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RelaxerOptions</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RelaxerOptions(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RelaxerOptions</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RelaxerOptions(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RelaxerOptions</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RelaxerOptions(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RelaxerOptions</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RelaxerOptions</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RelaxerOptions</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        switch_.clear();
        while (!stack.isEmptyElement()) {
            if (Switch.isMatch(stack)) {
                addSwitch(new Switch(stack));
            } else {
                break;
            }
        }
        option_.clear();
        while (!stack.isEmptyElement()) {
            if (Option.isMatch(stack)) {
                addOption(new Option(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("relaxerOptions");
        int size;
        size = this.switch_.size();
        for (int i = 0;i < size;i++) {
            Switch value = (Switch)this.switch_.get(i);
            value.makeElement(element);
        }
        size = this.option_.size();
        for (int i = 0;i < size;i++) {
            Option value = (Option)this.option_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RelaxerOptions</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RelaxerOptions</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>RelaxerOptions</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>RelaxerOptions</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>RelaxerOptions</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>RelaxerOptions</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the Switch property <b>switch</b>.
     *
     * @return Switch[]
     */
    public final Switch[] getSwitch() {
        Switch[] array = new Switch[switch_.size()];
        return ((Switch[])switch_.toArray(array));
    }

    /**
     * Sets the Switch property <b>switch</b>.
     *
     * @param switchValue
     */
    public final void setSwitch(Switch[] switchValue) {
        this.switch_.clear();
        this.switch_.addAll(java.util.Arrays.asList(switchValue));
    }

    /**
     * Sets the Switch property <b>switch</b>.
     *
     * @param switchValue
     */
    public final void setSwitch(Switch switchValue) {
        this.switch_.clear();
        this.switch_.add(switchValue);
    }

    /**
     * Adds the Switch property <b>switch</b>.
     *
     * @param switchValue
     */
    public final void addSwitch(Switch switchValue) {
        this.switch_.add(switchValue);
    }

    /**
     * Gets number of the Switch property <b>switch</b>.
     *
     * @return int
     */
    public final int getSwitchCount() {
        return (switch_.size());
    }

    /**
     * Gets the Switch property <b>switch</b> by index.
     *
     * @param index
     * @return Switch
     */
    public final Switch getSwitch(int index) {
        return ((Switch)switch_.get(index));
    }

    /**
     * Sets the Switch property <b>switch</b> by index.
     *
     * @param index
     * @param switchValue
     */
    public final void setSwitch(int index, Switch switchValue) {
        this.switch_.set(index, switchValue);
    }

    /**
     * Gets the Option property <b>option</b>.
     *
     * @return Option[]
     */
    public final Option[] getOption() {
        Option[] array = new Option[option_.size()];
        return ((Option[])option_.toArray(array));
    }

    /**
     * Sets the Option property <b>option</b>.
     *
     * @param option
     */
    public final void setOption(Option[] option) {
        this.option_.clear();
        this.option_.addAll(java.util.Arrays.asList(option));
    }

    /**
     * Sets the Option property <b>option</b>.
     *
     * @param option
     */
    public final void setOption(Option option) {
        this.option_.clear();
        this.option_.add(option);
    }

    /**
     * Adds the Option property <b>option</b>.
     *
     * @param option
     */
    public final void addOption(Option option) {
        this.option_.add(option);
    }

    /**
     * Gets number of the Option property <b>option</b>.
     *
     * @return int
     */
    public final int getOptionCount() {
        return (option_.size());
    }

    /**
     * Gets the Option property <b>option</b> by index.
     *
     * @param index
     * @return Option
     */
    public final Option getOption(int index) {
        return ((Option)option_.get(index));
    }

    /**
     * Sets the Option property <b>option</b> by index.
     *
     * @param index
     * @param option
     */
    public final void setOption(int index, Option option) {
        this.option_.set(index, option);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<relaxerOptions");
        buffer.append(">");
        size = this.switch_.size();
        for (int i = 0;i < size;i++) {
            Switch value = (Switch)this.switch_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.option_.size();
        for (int i = 0;i < size;i++) {
            Option value = (Option)this.option_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</relaxerOptions>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<relaxerOptions");
        buffer.print(">");
        size = this.switch_.size();
        for (int i = 0;i < size;i++) {
            Switch value = (Switch)this.switch_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.option_.size();
        for (int i = 0;i < size;i++) {
            Option value = (Option)this.option_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</relaxerOptions>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RelaxerOptions</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "relaxerOptions")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!Switch.isMatchHungry(target)) {
                break;
            }
        }
        while (!target.isEmptyElement()) {
            if (!Option.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RelaxerOptions</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RelaxerOptions</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
