/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.util.*;



/** 
 *  Binary tree container class.
 * (For JDK11)
 */ 

public class BTree implements GenericContainer,TreeStructure {

    BTreeNode root = BTreeNode.TERM;
    int count =0;
    

    /**    */ 
    public BTree() {
    }

    /**
     * @param com some object
     */ 
    final public void addElement(Comparable com) {
	BTreeNode tr = new BTreeNode(com);
	if (root == BTreeNode.TERM) {
	    //first commer
	    root = tr;
	} else {
	    //follow commer
	    root.set(tr);
	}
	count++;
    }

    /**
     * @param com some object
     */ 
    final public void removeElement(Comparable com) {
	if (root == BTreeNode.TERM) return;
	BTreeNode cc = new BTreeNode(com);
	BTreeNode tr = root.remove(cc);
	if (tr == null) {
	    //success
	    count--;
	    return;
	}
	if (tr == cc) {
	    System.err.println("cannot remove element.(BT)");
	    return; //failed
	}

	//deleted root, so change root object
	root = tr;
	count--;
    }

    /** remove all elements */
    final public void removeAllElements() {
	root.dispose();
	root =BTreeNode.TERM;
	count=0;
    }

    /**
     * This method searches the same object.
     * If even one object has the same value with argument object,
     *  it's different object,
     * return false.
     * @return if contains return true.
     */ 
    final public boolean contains(Comparable com) {
	return root.search(com);
    }

    /**
      * This method searches any object has the same value.
      * (or object returns true in the method "equals" )
      */
    final public Comparable getSameValue(Comparable com) {
	return root.searchOf(com);
    }

    /**
     *  update objects' position
     */ 
    final public void update() {
	if (root == BTreeNode.TERM) return;
	root = BTreeNode.TERM;
	Enumeration e = elements();
	while (e.hasMoreElements()) {
	    addElement((Comparable)e.nextElement());
	}
    }

    Object [] array;
    /**
     * @return enumeration object
     */ 
    final public Enumeration elements() {
	if (root == BTreeNode.TERM) return null;
	if (array == null || array.length < size() )
	    array = new Object[size()];
	root.browse(array,0);
	//collect_simple(array);
	return new SimpleEnumeration(array,size());
    }

    /* (too slow)
    private BTreeNode [] stack = new BTreeNode[20];
    private int [] stack2 = new int [20];
    private int stackPoint = 0;
    final private void collect_stack(Object [] array) {
	int stp = 0;
	int index = 0;
	int pos = 0;
	BTreeNode curNode = root;
	while(true) {
	    switch(pos) {
	    case -1:
		throw new InternalError();
	    case 0:
		if (curNode.lessChild != BTreeNode.TERM) {
		    push(curNode,1);
		    pos = 0;
		    curNode = curNode.lessChild;
		    break;
		}
	    case 1:
		array[index] = curNode.getObject();
		index++;
	    case 2:
		if (curNode.greatChild != BTreeNode.TERM) {
		    push(curNode,4);
		    curNode = curNode.greatChild;
		    pos = 0;
		    break;
		}
	    case 4:
		curNode = pop();
		pos = pop2();
		if (pos == -1) return;
		if (curNode == null) return;
	    }
	}
    }
    final private void push(BTreeNode t,int pos) {
	if (stack == null || stack.length <= stackPoint) {
	    //make new stack
	    BTreeNode [] tmp = new BTreeNode[stackPoint+10];
	    for (int i=0;i<stack.length;i++) {
		tmp[i] = stack[i];
	    }
	    stack = tmp;
	    int [] tmp2 = new int[stackPoint+10];
	    for (int i=0;i<stack2.length;i++) {
		tmp2[i] = stack2[i];
	    }
	    stack2 = tmp2;
	}
	stack[stackPoint] = t;
	stack2[stackPoint] = pos;
	stackPoint++;
    }
    final private BTreeNode pop() {
	if (stackPoint <= 0) return null;
	stackPoint--;
	return stack[stackPoint];
    }
    final private int pop2() {
	if (stackPoint < 0) return -1;
	return stack2[stackPoint];
    }
    */

    /** @return the object that had the least value. */
    final public Comparable firstElement() {
	if (root == BTreeNode.TERM) return null;
	BTreeNode node = root,less=null;
	while (node != BTreeNode.TERM) {
	    less = node;
	    node = node.lessChild;
	}
	return less.object;
    }

    /** @return the object that has greatest value. */
    final public Comparable lastElement() {
	if (root == BTreeNode.TERM) return null;
	BTreeNode node = root,great=null;
	while (node != BTreeNode.TERM) {
	    great = node;
	    node = node.greatChild;
	}
	return great.object;
    }
    
    final public boolean isEmpty() {
	return (count <= 0);
    }
	
    final public int size() {
	return count;
    }

    /** interfaces of GenericContainer */
    public void _addElement(Object obj) {addElement((Comparable)obj);}
    /** interfaces of GenericContainer */
    public void _removeElement(Object obj){removeElement((Comparable)obj);}
    /** interfaces of GenericContainer */
    public void _removeAllElements(){removeAllElements();}
    /** interfaces of GenericContainer */
    public boolean _isEmpty(){return isEmpty();}
    /** interfaces of GenericContainer */
    public Enumeration _elements(){return elements();}
    /** interfaces of GenericContainer */
    public int _size(){return size();}
    /** interfaces of GenericContainer */
    public boolean _contains(Object obj){return contains((Comparable)obj);}

    // TreeStructure stuff

    public String getTreeNodeExpression() {
	return "BTree("+size()+")";
    }

    public TreeStructure [] getTreeNodes() {
	if (size() == 0) return null;
	TreeStructure [] ts = {root};
	return ts;
    }
}


class BTreeNode implements TreeStructure {

    static BTreeNode TERM = new BTreeNode(null);

    Comparable object ;
    BTreeNode greatChild = TERM;
    BTreeNode lessChild = TERM;
    BTreeNode parent;

    final public void setObject(Comparable a) { object = a; }
    final public Comparable getObject() { return object; }

    BTreeNode(Comparable com) {
	object = com;
    }

    /** SET command */
    final void set(BTreeNode tr) {
	if (tr == null) return;
	if (greaterThan(tr)) 
	    setGreat(tr);
	else 
	    setLess(tr);
    }

    final private void setGreat(BTreeNode tr) {
	if (greatChild == TERM) {
	    //new
	    greatChild = tr;
	    tr.parent = this;
	}else {
	    //go down
	    greatChild.set(tr);
	}
    }

    final private void setLess(BTreeNode tr) {
	if (lessChild == TERM) {
	    //new
	    lessChild = tr;
	    tr.parent = this;
	}else {
	    // go down
	    lessChild.set(tr);
	}
    }

    /** SEARCH command */
    final boolean search(Comparable com) {
	if (com == object) return true;
	if (object.greaterThan(com)) {
	    if (greatChild != TERM) 
		return greatChild.search(com);
	    return false;
	} else {
	    if (lessChild != TERM) 
		return lessChild.search(com);
	    return false;
	}
	//return false;
    }

    /** SEARCH WITH VALUE command */
    final Comparable searchOf(Comparable com) {
	if (object.equals(com)) return object;
	if (object.greaterThan(com)) {
	    if (greatChild != TERM) 
		return greatChild.searchOf(com);
	    return null;
	} else {
	    if (lessChild != TERM) 
		return lessChild.searchOf(com);
	    return null;
	}
	//return false;
    }

    /** REMOVE command */
    final BTreeNode remove(BTreeNode tr) {
	if (tr.getObject() == getObject()) {
	    //is me!!
	    if (greatChild == TERM && lessChild == TERM) 
		return TERM;
	    if (greatChild == TERM)
		return lessChild;
	    if (lessChild == TERM)
		return greatChild;
	    greatChild.set(lessChild);
	    return greatChild;
	} else {
	    //which?
	    BTreeNode ret;
	    if (greaterThan(tr)) {
		//great one
		if (greatChild == TERM) {
		    //there is nothing to delete
		    return tr;
		}
		ret = greatChild.remove(tr);
		if (ret == tr) return tr; //missed
		if (ret == null) return null; //successfull
		greatChild =TERM;
		if (ret != TERM)
		    set(ret); // down node was deleted
		return null;//success
	    } else {
		//less one
		if (lessChild == TERM) {
		    //there is nothing to delete
		    return tr;
		}
		ret = lessChild.remove(tr);
		if (ret == tr) return tr; //missed
		if (ret == null) return null; //successfull
		lessChild = TERM;
		if (ret != TERM)
		    set(ret); // down node was deleted
		return null;//success
	    }
	}
	//return null;
    }

    final int browse(Object[] div,int count) {
	if (lessChild != TERM) count = lessChild.browse(div,count);
	div[count] = object;
	count++;
	if (greatChild != TERM) count = greatChild.browse(div,count);
	return count;
    }

    final void dispose() {
	if (lessChild != TERM) {
	    lessChild.dispose();
	    lessChild = TERM;
	}
	if (greatChild != TERM) {
	    greatChild.dispose();
	    greatChild = TERM;
	}
	object = null;
	parent = null;
    }

    final boolean greaterThan(BTreeNode tr) {
	return tr.getObject().greaterThan(getObject());
    }

    // TreeStructure stuff

    public String getTreeNodeExpression() {
	if (this == TERM) return "TERM";
	return "Node("+object+")";
    }

    public TreeStructure [] getTreeNodes() {
	if (this == TERM) return null;
	if (lessChild == TERM && greatChild == TERM) return null;
	TreeStructure [] ts = {lessChild,greatChild};
	return ts;
    }
}

