/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.util;
import java.util.*;


/** 
 *  This class makes Enumeration object from the array object.
 *  
 */

public class SimpleEnumeration implements Enumeration {
    int count =0;

    Object []  objects ;
    int length = 0;


    /** 
     *  make Enumeration object from the array object.
     *  @param array object
     */
    public SimpleEnumeration(Object[] obj) {
	if (obj == null) 
	    System.out.println("no objects. in SimpleEnumeration.");
	objects = obj;
	length = obj.length;
    }

    /** 
     *  make Enumeration object from the array object.
     * @param array object
     * @param length length of array
     */
    public SimpleEnumeration(Object[] obj,int length) {
	if (obj == null) 
	    System.out.println("no objects. in SimpleEnumeration.");
	objects = obj;
	this.length = length;
    }

    /**
     * make Enumeration object from one object.
     * 
     * @param obj 
     */
    public  SimpleEnumeration(Object obj) {
	if (obj == null) 
	    System.out.println("no objects. in SimpleEnumeration.");
	objects = new Object[1];
	objects[0] = obj;
    }

    public Object nextElement() {
	count++;
	return objects[count-1];
    }

    public boolean hasMoreElements() {
	if (count >= length) return false;
	return true;
    }

    /**
     * set the internal position on the first element.
     *  
     * @return ...
     */
    public void setHeadPosition () {
	count = -1;
    }



}

