/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import ccs.comp.ngraph.PlotComponent;
import ccs.comp.ngraph.PlotRenderer;
import ccs.math.RealRange;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class BufferedImagePlotComponent
implements PlotComponent {
    private BufferedImage image;
    private Vector rendererList = new Vector();
    private Dimension lastSize = null;

    public BufferedImagePlotComponent(int width, int height) {
        this(width, height, 1);
    }

    public BufferedImagePlotComponent(int width, int height, int model) {
        this.image = new BufferedImage(width, height, model);
    }

    public void addRenderer(PlotRenderer renderer, RealRange configRatio) {
        if (renderer == null) {
            return;
        }
        if (configRatio == null) {
            configRatio = new RealRange(0.0, 0.0, 1.0, 1.0);
        } else if (configRatio.getDimension() != 2) {
            System.err.println("Configration ratio is invalid. [" + configRatio.getDimension() + "]");
            return;
        }
        RendererHolder holder = new RendererHolder();
        holder.renderer = renderer;
        holder.configRatio = configRatio;
        this.rendererList.addElement(holder);
        renderer.setParentComponent((PlotComponent)this);
    }

    public void addRenderer(PlotRenderer renderer) {
        this.addRenderer(renderer, null);
    }

    public Component getComponent() {
        return null;
    }

    public BufferedImage getImage() {
        this.repaintOrder();
        return this.image;
    }

    public void repaintOrder() {
        this.paintComponent(this.image.createGraphics());
    }

    public void paintComponent(Graphics g) {
        Dimension size = new Dimension(this.image.getWidth(), this.image.getHeight());
        Rectangle borderArea = new Rectangle();
        int i = 0;
        while (i < this.rendererList.size()) {
            RendererHolder holder = (RendererHolder)this.rendererList.elementAt(i);
            RealRange ratio = holder.configRatio;
            borderArea.x = (int)((double)size.width * ratio.x());
            borderArea.y = (int)((double)size.height * ratio.y());
            borderArea.width = (int)((double)size.width * ratio.width());
            borderArea.height = (int)((double)size.height * ratio.height());
            holder.renderer.paint(g, borderArea);
            ++i;
        }
    }

    class RendererHolder {
        PlotRenderer renderer;
        RealRange configRatio;

        RendererHolder() {
        }
    }
}

