/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import jp.gr.java_conf.ccs2.comp.FontInfo;
import jp.gr.java_conf.ccs2.comp.OriginalFont;

public class RichString {
    protected FontInfo orgFont;
    protected int fontNumber = 0;
    protected String contents;
    protected int voff = 3;
    protected int hoff = 3;
    private int ac;
    private int dc;
    private boolean changed = true;
    private Dimension currentSize;

    public RichString() {
        this("", Color.black, null, new Font("SansSerif", 0, 12));
    }

    public RichString(String c, Color f, Color b, Font a) {
        this.contents = c;
        this.orgFont = new OriginalFont(f, b, a);
    }

    public RichString(String c, FontInfo orf) {
        this(c, orf, 0);
    }

    public RichString(String c, FontInfo orf, int num) {
        this.contents = c;
        this.orgFont = orf;
        this.fontNumber = num;
    }

    void setFontInfo(FontInfo f) {
        this.orgFont = f;
        this.changed = true;
    }

    void setFontNumber(int f) {
        this.fontNumber = f;
        this.changed = true;
    }

    public void setContents(String s) {
        this.contents = s;
        this.changed = true;
    }

    public String getContents() {
        return this.contents;
    }

    public FontInfo getFontInfo() {
        return this.orgFont;
    }

    public Color getForeground() {
        return this.orgFont.getColor(0);
    }

    public Color getBackground() {
        return this.orgFont.getColor(1);
    }

    public Font getFont() {
        return this.orgFont.getFont(this.fontNumber);
    }

    public int getVarticalOffset() {
        return this.voff;
    }

    public int getHolizontalOffset() {
        return this.hoff;
    }

    public void setVarticalOffset(int v) {
        this.voff = v;
    }

    public void setHolizontalOffset(int h) {
        this.hoff = h;
    }

    public Dimension getSize(Component c) {
        if (this.changed) {
            this.mesureSize(c.getFontMetrics(this.getFont()));
        }
        return this.currentSize;
    }

    public Dimension getSize(Graphics g) {
        if (this.changed) {
            this.mesureSize(g.getFontMetrics(this.getFont()));
        }
        return this.currentSize;
    }

    protected void mesureSize(FontMetrics fm) {
        this.currentSize = new Dimension();
        if (fm != null) {
            this.currentSize.height = fm.getHeight() + this.voff * 2;
            this.currentSize.width = fm.stringWidth(this.contents) + this.hoff * 2;
            this.ac = fm.getAscent();
            this.dc = fm.getDescent();
            this.changed = false;
        } else {
            System.out.println("Null FontMetrics");
            this.currentSize.height = this.getFont().getSize() + this.hoff * 2;
            this.currentSize.width = this.getFont().getSize() * this.contents.length();
        }
    }

    public Dimension drawContents(Graphics g, int x, int y) {
        Dimension d = this.getSize(g);
        Color bc = this.getBackground();
        if (bc != null) {
            g.setColor(bc);
            g.fillRect(x, y, d.width, d.height);
        }
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        g.drawString(this.contents, x += this.hoff, y += this.ac + this.voff);
        return d;
    }
}

