/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jp.gr.java_conf.ccs2.comp.MessageListener;

public class Shader
extends Canvas
implements Runnable {
    public static final int PLAIN = 0;
    public static final int ITALIC = 1;
    public static final int BOLD = 2;
    public static final int defaultRight = 7;
    public static final int defaultDown = 6;
    public static final int defaultForColor = 0xCCCCCC;
    public static final int defaultBackColor = 0xFFFFFF;
    public static final int defaultTitleColor = 0x99BB99;
    public static final int defaultDepth = 10;
    public static final String defaultFontname = "Serif";
    public static final int defaultFontstyle = 0;
    public static final int defaultFontsize = 30;
    String title;
    int backColor;
    int forColor;
    int titleColor;
    int depth;
    int right;
    int down;
    int wright;
    int wdown;
    int width;
    int height;
    String fontname;
    int fontstyle;
    int fontsize;
    MessageListener parent = null;
    double frexx = 0.0;
    double frexy = 0.0;
    int frontdepth = 2;
    int xoffset;
    int yoffset;
    int lastWidth;
    int lastHeight;
    boolean fix = true;
    boolean selfResize = false;
    Image ibackOffice;
    Graphics gbackOffice;
    Image imgr;
    int isDraw;
    boolean paintRequest = false;
    Thread writer;
    static final int READY = 0;
    static final int PAINTING = 1;
    static final int FINISHED = 2;
    static final int FIRST = 3;
    int[] data = new int[320];

    public static void main(String[] arg) {
        String put = "Shader sample!!";
        int fg = 0xCCCCCC;
        int bg = 0xFFFFFF;
        int wc = 0x99BB99;
        if (arg.length != 4) {
            System.out.println("stand alone usage sample:");
            System.out.println("% java jp.gr.java_conf.ccs2.comp.Shader [word] [0x000000:fg color] [0x000000:bg color] [0x000000:word color]");
        } else {
            put = arg[0];
            fg = Integer.decode(arg[1]);
            bg = Integer.decode(arg[2]);
            wc = Integer.decode(arg[3]);
        }
        JFrame f = new JFrame("Shader example");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Shader sh = new Shader(put, fg, bg, wc, 15, 0, 0, defaultFontname, 40, 1);
        f.getContentPane().add((Component)sh, "Center");
        f.pack();
        f.show();
    }

    public Shader() {
        this("Shader Component");
    }

    public Shader(String title) {
        this(title, 0xCCCCCC, 0xFFFFFF, 0x99BB99, defaultFontname, 30, 0);
    }

    public Shader(String title, int fcol, int bcol, int wcol, String font, int large, int style) {
        this(title, fcol, bcol, wcol, 10, 7, 6, font, large, style);
    }

    public Shader(String title, int fcol, int bcol, int wcol, int depth, int right, int down, String font, int large, int style) {
        this(title, fcol, bcol, wcol, depth, right, down, font, large, style, 0, 0);
        this.selfResize = true;
    }

    public Shader(String title, int width, int height) {
        this(title, 0xCCCCCC, 0xFFFFFF, 0x99BB99, 10, 7, 6, defaultFontname, 0, 0, width, height);
    }

    public Shader(String title, int fcol, int bcol, int wcol, int depth, int right, int down, String font, int style, int width, int height) {
        this(title, fcol, bcol, wcol, depth, right, down, font, 0, style, width, height);
    }

    public Shader(String title, int fcol, int bcol, int wcol, int depth, int right, int down, String font, int large, int style, int width, int height) {
        int i = 0;
        while (i < 320) {
            this.data[i] = (int)(Math.sin((double)(i % 256) * Math.PI / 128.0) * 1024.0);
            ++i;
        }
        this.title = title;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.right = right;
        this.down = down;
        if (this.right < 0) {
            this.wright = -this.right;
            this.right = 0;
        } else {
            this.wright = 0;
        }
        if (this.down < 0) {
            this.wdown = -this.down;
            this.down = 0;
        } else {
            this.wdown = 0;
        }
        this.titleColor = wcol;
        this.backColor = bcol;
        this.forColor = fcol;
        this.depth = depth;
        this.fontname = font;
        this.fontsize = large;
        this.fontstyle = style;
        if (width != 0) {
            this.setSize(width, height);
        } else {
            this.width = this.fontsize * title.length();
            this.height = this.fontsize * 2;
            this.setSize(this.width, this.height);
        }
        this.setDraw(3);
    }

    public void setSize(int w, int h) {
        this.selfResize = false;
        super.setSize(w, h);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension(this.width, this.height);
        return d;
    }

    public void setSize(Dimension d) {
        this.selfResize = false;
        super.setSize(d);
    }

    public void setTitle(String title) {
        this.title = title;
        this.urgeRepaint();
    }

    public String getTitle() {
        return this.title;
    }

    public void paint(Graphics g) {
        this.branch(g);
        if (this.paintRequest) {
            this.paintRequest = false;
            Runnable updateAComponent = new Runnable(){

                public void run() {
                    Shader.this.repaint();
                }
            };
            SwingUtilities.invokeLater(updateAComponent);
        }
    }

    public void run() {
        this.lastWidth = this.width;
        this.lastHeight = this.height;
        this.ibackOffice = this.createImage(this.width, this.height);
        this.gbackOffice = this.ibackOffice.getGraphics();
        this.makeGraph(this.gbackOffice);
        this.setDraw(2);
        if (this.parent != null) {
            this.parent.message("", 0, new Dimension(this.width, this.height));
        }
        this.invalidate();
        Runnable updateAComponent = new Runnable(){

            public void run() {
                Shader.this.repaint();
            }
        };
        SwingUtilities.invokeLater(updateAComponent);
    }

    public void addNotify() {
        super.addNotify();
        if (this.selfResize) {
            FontMetrics fm = this.getFontMetrics(new Font(this.fontname, 0, (this.fontsize + this.depth) * 3));
            this.xoffset = (Math.abs(this.right) + Math.abs(this.wright)) * 2;
            this.yoffset = (Math.abs(this.down) + Math.abs(this.wdown)) * 2;
            this.setSize(fm.stringWidth(this.title) + this.xoffset, fm.getHeight() + this.yoffset);
        }
    }

    private synchronized void setDraw(int a) {
        this.isDraw = a;
    }

    private synchronized int getDraw() {
        return this.isDraw;
    }

    private void urgeRepaint() {
        if (this.getDraw() == 2) {
            this.setDraw(0);
        }
        Runnable updateAComponent = new Runnable(){

            public void run() {
                Shader.this.repaint();
            }
        };
        SwingUtilities.invokeLater(updateAComponent);
    }

    private synchronized void branch(Graphics g) {
        Dimension d = this.getSize();
        this.width = d.width;
        this.height = d.height;
        switch (this.getDraw()) {
            default: {
                this.setDraw(1);
                this.threadStart();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.ibackOffice == null || this.width != this.lastWidth || this.height != this.lastHeight) {
                    this.setDraw(0);
                    this.paintRequest = true;
                    break;
                }
                g.drawImage(this.ibackOffice, 0, 0, this);
                this.writer = null;
            }
        }
    }

    private String[] splitString(String t) {
        t = t.replace('~', ' ');
        int length = t.length();
        String[] ws = new String[length];
        int i = 0;
        while (i < length) {
            ws[i] = new String(t.substring(i, i + 1));
            ++i;
        }
        return ws;
    }

    private Font[] makeFonts(String name, int style, int baseSize, int d) {
        int tstyle = 0;
        if ((style & 0) != 0) {
            tstyle = 1;
        }
        if ((style & 1) != 0) {
            tstyle += 2;
        }
        Font[] fs = new Font[d];
        int i = 0;
        while (i < d) {
            fs[i] = new Font(name, tstyle, baseSize + i);
            ++i;
        }
        return fs;
    }

    private Color[] makeColors(int d, int fcol, int bcol, int wcol) {
        int br = (this.backColor >> 16) % 256;
        int bg = (this.backColor >> 8) % 256;
        int bb = this.backColor % 256;
        double fr = (this.forColor >> 16) % 256;
        double fg = (this.forColor >> 8) % 256;
        double fb = this.forColor % 256;
        Color[] colorIndex = new Color[d];
        int i = 0;
        while (i < d) {
            int cr = br + (int)((fr - (double)br) * (double)i * (double)i / (double)d / (double)d) % 256;
            int cg = bg + (int)((fg - (double)bg) * (double)i * (double)i / (double)d / (double)d) % 256;
            int cb = bb + (int)((fb - (double)bb) * (double)i * (double)i / (double)d / (double)d) % 256;
            if (cb > 255) {
                cb = 255;
            }
            if (cg > 255) {
                cg = 255;
            }
            if (cr > 255) {
                cr = 255;
            }
            colorIndex[this.depth - i - 1] = new Color(cr, cg, cb);
            ++i;
        }
        return colorIndex;
    }

    private void threadStart() {
        if (this.writer == null) {
            this.writer = new Thread(this);
            this.writer.start();
        }
    }

    private synchronized void makeGraph(Graphics g) {
        FontMetrics fm;
        int tx;
        Color[] colorIndex;
        int length;
        String[] words;
        block14: {
            int ty;
            words = this.splitString(this.title);
            length = this.title.length();
            colorIndex = this.makeColors(this.depth, this.forColor, this.backColor, this.titleColor);
            this.xoffset = Math.abs(this.right) + Math.abs(this.wright);
            this.yoffset = Math.abs(this.down) + Math.abs(this.wdown);
            if (this.fontsize == 0 || this.fix) {
                this.fix = true;
                tx = this.width / length;
                ty = this.height / 2;
                this.fontsize = tx > ty ? ty : tx;
            }
            do {
                Font tf = new Font(this.fontname, this.fontstyle, this.fontsize + this.depth - 2);
                g.setFont(tf);
                fm = g.getFontMetrics();
                tx = 2 * this.xoffset;
                int i = 0;
                while (i < length) {
                    tx += fm.stringWidth(words[i]);
                    ++i;
                }
                ty = fm.getHeight() + 2 * this.yoffset;
                if (tx < this.width && ty < this.height) {
                    this.xoffset = this.width / 2 - tx / 2;
                    break block14;
                }
                double mp = tx < this.width ? (double)this.width / (double)tx : (double)this.height / (double)ty;
                if (mp < 0.8) {
                    this.fontsize = (int)((double)this.fontsize * mp);
                }
                this.fontsize -= 3;
            } while (this.fontsize >= 9);
            this.fontsize = 9;
        }
        Font[] fonts = this.makeFonts(this.fontname, this.fontstyle, this.fontsize, this.depth);
        g.setColor(colorIndex[this.depth - 1]);
        g.fillRect(0, 0, this.width, this.height);
        g.setFont(fonts[this.depth - 1]);
        fm = g.getFontMetrics();
        int[] ddx = new int[length];
        int i = 0;
        while (i < length) {
            ddx[i] = fm.stringWidth(words[i]);
            ++i;
        }
        this.yoffset += this.height / 2 + (fm.getAscent() - fm.getDescent()) / 4;
        int checkx = 0;
        int checky = 0;
        int cx = 0;
        int cy = 0;
        int i2 = this.depth - 1;
        while (i2 > 0) {
            int ii = i2 - 1;
            g.setColor(colorIndex[i2]);
            g.setFont(fonts[i2]);
            int tt = i2 * this.frontdepth;
            if (i2 == this.depth - 1) {
                ii += 2;
            }
            if (i2 == this.depth - 2) {
                ++ii;
            }
            int jj = 0;
            while (jj < tt) {
                int ph = 256 * jj / tt;
                int dx = i2 + 4 + ii * this.cos(ph) >> 10;
                int dy = i2 + ii * this.sin(ph) >> 10;
                tx = 0;
                cx = this.xoffset + this.right + dx;
                cy = this.yoffset + this.down + dy;
                int j = 0;
                while (j < length) {
                    g.drawString(words[j], cx + tx, cy);
                    tx += ddx[j] - 2;
                    ++j;
                }
                if (checkx < (cx += tx)) {
                    checkx = cx;
                }
                if (checky < cy) {
                    checky = cy;
                }
                ++jj;
            }
            --i2;
        }
        g.setColor(new Color(this.titleColor));
        tx = 0;
        int j = 0;
        while (j < length) {
            g.drawString(words[j], this.xoffset + tx + this.wright + (int)(this.frexx * (double)this.depth), this.yoffset + this.wdown + (int)(this.frexy * (double)this.depth));
            tx += ddx[j] - 2;
            ++j;
        }
    }

    int sin(int deg) {
        return this.data[deg &= 0xFF];
    }

    int cos(int deg) {
        deg = (deg & 0xFF) + 64;
        return this.data[deg];
    }
}

