/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.core;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.ccs2.core.AppConfig;
import jp.gr.java_conf.ccs2.core.AppContext;
import jp.gr.java_conf.ccs2.core.DefaultAppConfig;
import jp.gr.java_conf.ccs2.core.DefaultMonitor;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public abstract class AppContextClass
implements AppContext {
    protected MessageMonitor monitor;
    protected AppConfig config;
    protected String resourceUri;
    ResourceBundle resources;
    boolean loadFailed = false;

    protected AppContextClass(String[] args) {
        this(args, null);
    }

    protected AppContextClass(String[] args, String resourceUri) {
        this.resourceUri = resourceUri;
        this.config = new DefaultAppConfig(args);
        this.setupMonitor();
    }

    protected AppContextClass(AppConfig conf, String resourceUri) {
        this.resourceUri = resourceUri;
        this.config = conf;
        this.setupMonitor();
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    protected void setupMonitor() {
        this.monitor = new DefaultMonitor(this.config);
    }

    public AppConfig getConfig() {
        return this.config;
    }

    public MessageMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(MessageMonitor m) {
        this.monitor = m;
    }

    protected void loadResources() {
        Locale locale = Locale.getDefault();
        try {
            this.resources = ResourceBundle.getBundle(this.resourceUri, locale);
        }
        catch (MissingResourceException mre) {
            this.getMonitor().error("property file [" + this.resourceUri + "] not found");
            this.loadFailed = true;
        }
    }

    public String getResourceString(String resourceName) {
        if (this.resources == null && !this.loadFailed) {
            this.loadResources();
        }
        try {
            return this.resources.getString(resourceName);
        }
        catch (RuntimeException e) {
            this.getMonitor().warning("no string :" + resourceName);
            return resourceName;
        }
    }

    public String getResourceStringNoWarning(String resourceName) {
        if (this.resources == null && !this.loadFailed) {
            this.loadResources();
        }
        try {
            return this.resources.getString(resourceName);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String getResourceString(String resName, String arg) {
        return MessageFormat.format(this.getResourceString(resName), arg);
    }
}

