/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.io;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jp.gr.java_conf.ccs2.io.AbstractReader;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class EasyReader
extends AbstractReader {
    public EasyReader(String filename) {
        super(EasyReader.openInput(filename));
    }

    public EasyReader(String filename, String encoding) {
        super(EasyReader.openInput(filename, encoding));
    }

    public static BufferedReader openInput(String filename) {
        return EasyReader.openInput(filename, null);
    }

    public static BufferedReader openInput(String filename, String encoding) {
        if (StringUtil.isNull(encoding)) {
            encoding = System.getProperty("file.encoding");
        }
        if (filename == null) {
            System.err.println(" null filename in EasyReader. ");
            return null;
        }
        if (filename.equals("")) {
            System.err.println(" null string(\"\") filename in EasyReader. ");
            return null;
        }
        BufferedReader tin = null;
        try {
            tin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
        }
        catch (IOException e) {
            System.err.println("I/O Exception was occured in EasyReader.");
        }
        return tin;
    }

    public static void main(String[] args) {
        EasyReader file = new EasyReader("test1");
        while (!file.isEOF()) {
            System.out.println(file.read());
        }
    }
}

