/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import jp.gr.java_conf.ccs2.sql.DBAccess;
import jp.gr.java_conf.ccs2.sql.JDBCUtil;
import jp.gr.java_conf.ccs2.sql.NativeDBCommand;

public class DBAccessContext {
    private Connection connection;
    private String preparedSql = null;

    public DBAccessContext() {
    }

    public DBAccessContext(Connection connection) {
        this.initConnection(connection);
    }

    public void initConnection(Connection con) {
        this.connection = con;
    }

    public void setPreparedSql(String sql) {
        this.preparedSql = sql;
    }

    private Statement getStatement() throws SQLException {
        if (this.preparedSql == null) {
            return this.connection.createStatement();
        }
        return this.connection.prepareStatement(this.preparedSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAccess(DBAccess client) {
        Statement stmt = null;
        try {
            stmt = this.getStatement();
            client.access(stmt);
        }
        catch (SQLException e) {
            client.exceptionHandler(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                client.exceptionHandler(e);
            }
        }
    }

    public void doAccessAtOnce(DBAccess client) {
        this.doAccessAtOnce(new DBAccess[]{client});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAccessAtOnce(DBAccess[] clients) {
        if (clients == null || clients.length == 0) {
            return;
        }
        try {
            int i = 0;
            while (i < clients.length) {
                this.doAccess(clients[i]);
                ++i;
            }
        }
        finally {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                clients[0].exceptionHandler(e);
            }
        }
    }

    public void doTransactionAccessAtOnce(DBAccess client, String[] tables) {
        this.doTransactionAccessAtOnce(new DBAccess[]{client}, tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTransactionAccess(DBAccess[] clients, String[] tables) {
        if (clients == null || clients.length == 0) {
            return;
        }
        Statement stmt = null;
        NativeDBCommand command = null;
        try {
            this.connection.setAutoCommit(false);
            command = JDBCUtil.getNativeDBCommand(this.connection);
            stmt = this.getStatement();
            command.lockTables(stmt, tables, true);
            int i = 0;
            while (i < clients.length) {
                clients[i].access(stmt);
                ++i;
            }
            command.unlockTables(stmt, tables);
            this.connection.commit();
        }
        catch (SQLException e) {
            if (command != null && stmt != null) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException ex) {
                    clients[0].exceptionHandler(ex);
                }
            }
            clients[0].exceptionHandler(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                clients[0].exceptionHandler(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTransactionAccessAtOnce(DBAccess[] clients, String[] tables) {
        try {
            this.doTransactionAccess(clients, tables);
        }
        finally {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                clients[0].exceptionHandler(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLockedAccessAtOnce(DBAccess client, String[] tables) {
        Statement stmt = null;
        NativeDBCommand command = null;
        try {
            command = JDBCUtil.getNativeDBCommand(this.connection);
            stmt = this.getStatement();
            this.connection.setAutoCommit(false);
            command.lockTables(stmt, tables, false);
            client.access(stmt);
            command.unlockTables(stmt, tables);
            this.connection.commit();
        }
        catch (SQLException e) {
            if (command != null && stmt != null) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException ex) {
                    client.exceptionHandler(ex);
                }
            }
            client.exceptionHandler(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                client.exceptionHandler(e);
            }
        }
    }

    public void closeConnection(DBAccess client) {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            client.exceptionHandler(e);
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

