/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.ccs2.sql.NativeDBCommand;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class JDBCUtil {
    private static Map driverMap = new HashMap();
    private static ResourceBundle dbResource;
    private static HashMap tableMap;
    private static char[] orgChars;
    private static String[] replaceChars;

    public static void row2map(ResultSet set, HashMap map) throws SQLException {
        map.clear();
        ResultSetMetaData rsmd = set.getMetaData();
        int cols = rsmd.getColumnCount();
        int i = 0;
        while (i < cols) {
            String colName = rsmd.getColumnName(i + 1).toLowerCase();
            map.put(colName, set.getObject(i + 1));
            ++i;
        }
    }

    public static boolean registDriver(String driverClassName) {
        if (driverMap.get(driverClassName) != null) {
            return true;
        }
        try {
            driverMap.put(driverClassName, Class.forName(driverClassName).newInstance());
            return true;
        }
        catch (Exception e) {
            System.err.println("Unable to load driver [" + driverClassName + "].");
            e.printStackTrace();
            return false;
        }
    }

    public static NativeDBCommand getNativeDBCommand(Statement stat) throws SQLException {
        return JDBCUtil.getNativeDBCommand(stat.getConnection());
    }

    public static NativeDBCommand getNativeDBCommand(Connection con) throws SQLException {
        String name = con.getMetaData().getDatabaseProductName();
        name = StringUtil.replace(name, " ", "_");
        if (dbResource == null) {
            dbResource = ResourceBundle.getBundle("jp.gr.java_conf.ccs2.sql.nativedb");
        }
        String cname = "";
        try {
            cname = dbResource.getString(name);
            Class<?> cls = Class.forName(cname);
            return (NativeDBCommand)cls.newInstance();
        }
        catch (MissingResourceException e) {
            System.err.println("Missing DB class name [" + name + "]");
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            System.err.println("InstantiationException [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("IllegalAccessException [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.err.println("can not load the class [" + cname + "]");
            e.printStackTrace();
        }
        throw new InternalError();
    }

    public static int getRowNumber(ResultSet rs) throws SQLException {
        if (rs == null) {
            return 0;
        }
        rs.last();
        int cc = rs.getRow();
        rs.beforeFirst();
        return cc;
    }

    public static int getColumnType(Connection con, String table, String column) throws SQLException {
        Integer it;
        HashMap<String, Integer> columnOfTable = (HashMap<String, Integer>)tableMap.get(table);
        if (columnOfTable == null) {
            columnOfTable = new HashMap<String, Integer>();
            tableMap.put(table, columnOfTable);
        }
        if ((it = (Integer)columnOfTable.get(column)) != null) {
            return it;
        }
        DatabaseMetaData meta = con.getMetaData();
        ResultSet rs = meta.getColumns(con.getCatalog(), "", table, column);
        if (rs.next()) {
            int tp = rs.getInt("DATA_TYPE");
            columnOfTable.put(column, new Integer(tp));
            return tp;
        }
        throw new SQLException("No such column ... [" + table + "." + column + "]");
    }

    public static boolean isCharTypeColumn(Connection con, String table, String column) throws SQLException {
        int type = JDBCUtil.getColumnType(con, table, column);
        return type == 12 || type == 1 || type == 92 || type == 93 || type == 91 || type == -1;
    }

    public static String makeSqlConstant(Statement stat, String table, String column, String in) throws SQLException {
        return JDBCUtil.makeSqlConstant(stat.getConnection(), table, column, in);
    }

    public static String makeSqlConstant(Connection con, String table, String column, String in) throws SQLException {
        if (JDBCUtil.isCharTypeColumn(con, table, column)) {
            return "'" + JDBCUtil.escape(in, con) + "'";
        }
        return in;
    }

    public static String escape(String in, Statement stat) {
        try {
            return JDBCUtil.escape(in, stat.getConnection());
        }
        catch (SQLException e) {
            System.err.println("SQLException : " + e.getMessage());
            return JDBCUtil.defaultEscape(in);
        }
    }

    public static String escape(String in, Connection con) {
        try {
            NativeDBCommand com = JDBCUtil.getNativeDBCommand(con);
            return com.escape(in);
        }
        catch (SQLException e) {
            System.err.println("SQLException : " + e.getMessage());
            return JDBCUtil.defaultEscape(in);
        }
    }

    public static String defaultEscape(String text) {
        return StringUtil.escape(text, orgChars, replaceChars);
    }

    static {
        tableMap = new HashMap();
        orgChars = new char[]{'\\', '\'', '%'};
        replaceChars = new String[]{"\\\\", "\\'", "\\%"};
    }
}

