/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.sql.db;

import java.sql.SQLException;
import java.sql.Statement;
import jp.gr.java_conf.ccs2.sql.JDBCUtil;
import jp.gr.java_conf.ccs2.sql.NativeDBCommand;

public class MySQLCommand
implements NativeDBCommand {
    public String getDBName() {
        return "MySQL";
    }

    public void lockTables(Statement stmt, String[] tables, boolean writeLock) throws SQLException {
        if (tables == null || tables.length == 0) {
            return;
        }
        boolean[] ls = new boolean[tables.length];
        int i = 0;
        while (i < tables.length) {
            ls[i] = writeLock;
            ++i;
        }
        this.lockTables(stmt, tables, ls);
    }

    public void lockTables(Statement stmt, String[] tables, boolean[] writeLock) throws SQLException {
        if (tables == null || tables.length == 0) {
            return;
        }
        String sql = "LOCK TABLES ";
        int i = 0;
        while (i < tables.length) {
            sql = sql + tables[i];
            sql = writeLock[i] ? sql + " WRITE," : sql + " READ,";
            ++i;
        }
        stmt.executeUpdate(sql.substring(0, sql.length() - 1));
    }

    public void unlockTables(Statement stmt, String[] tables) throws SQLException {
        stmt.executeUpdate("UNLOCK TABLES");
    }

    public String escape(String text) {
        return JDBCUtil.defaultEscape(text);
    }
}

