/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.awt.Color;

public class ColorSet {
    public static Color[] geographIndex = new Color[]{new Color(0xCC00CC), Color.blue, Color.cyan, Color.yellow, Color.green, Color.red};
    public static Color[] rainbowIndex = new Color[]{new Color(0xCC00CC), Color.blue, Color.green, Color.yellow, Color.orange, Color.red};
    private int alpha = 255;
    private Color[] genIndex;
    private int number;
    private Color[] index;
    private boolean rev = false;

    public ColorSet(Color zeroc, Color endc, int num) {
        this.genIndex = new Color[]{zeroc, endc};
        this.number = num;
    }

    public ColorSet(Color[] colors, int num) {
        this.genIndex = colors;
        this.number = num;
    }

    public ColorSet(Color[] colors) {
        this.genIndex = colors;
        this.number = colors.length;
    }

    public Color[] getColors() {
        return this.genIndex;
    }

    public static Color[] makeColorIndex(Color[] set, int num) {
        return ColorSet.makeColorIndex(set, num, 255);
    }

    public static Color[] makeColorIndex(Color[] set, int num, int alpha) {
        Color[] colorIndex = new Color[num];
        if (set.length == 1) {
            int i = 0;
            while (i < num) {
                colorIndex[i] = set[0];
                ++i;
            }
            return colorIndex;
        }
        int i = 0;
        while (i < num) {
            double vc = (double)(set.length - 1) / (double)num * (double)i;
            int ivc = (int)vc;
            Color low = set[ivc];
            Color hi = set[ivc + 1];
            double rh = vc - (double)ivc;
            double rl = 1.0 - rh;
            double br = low.getRed();
            double bg = low.getGreen();
            double bb = low.getBlue();
            double fr = hi.getRed();
            double fg = hi.getGreen();
            double fb = hi.getBlue();
            int cc = (int)(br * rl + fr * rh) * 65536 + (int)(bg * rl + fg * rh) * 256 + (int)(bb * rl + fb * rh) + (alpha << 24);
            colorIndex[i] = alpha == 255 ? new Color(cc) : new Color(cc, true);
            ++i;
        }
        return colorIndex;
    }

    public void setReversible(boolean b) {
        this.rev = b;
    }

    public void setAlpha(int a) {
        this.alpha = a;
    }

    public int getNumberOfColors() {
        return this.number;
    }

    public Color getColor(int i) {
        if (this.index == null) {
            this.index = ColorSet.makeColorIndex(this.genIndex, this.number, this.alpha);
        }
        if (i < 0) {
            i = this.rev ? -i : 0;
        }
        if (this.index.length <= i) {
            i = this.index.length - 1;
        }
        return this.index[i];
    }

    public Color getColor(double d) {
        return this.getColor((int)Math.rint(d * (double)this.number));
    }

    public int getRGB(double d) {
        int colorNumber = this.number - 1;
        int lowIndex = (int)(d * (double)colorNumber);
        Color low = this.getColor(lowIndex);
        Color hi = this.getColor(lowIndex + 1);
        double discreteSize = 1.0 / (double)colorNumber;
        double hiMix = d / discreteSize - (double)lowIndex;
        double lowMix = 1.0 - hiMix;
        return (int)((double)low.getRed() * lowMix + (double)hi.getRed() * hiMix) * 65536 + (int)((double)low.getGreen() * lowMix + (double)hi.getGreen() * hiMix) * 256 + (int)((double)low.getBlue() * lowMix + (double)hi.getBlue() * hiMix) + (this.alpha << 24);
    }
}

