/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.LinkedList;
import jp.gr.java_conf.ccs2.util.TreeStructure;
import jp.gr.java_conf.ccs2.util.TreeStructureClass;

public class TreeStructureUtil {
    public static TreeStructure object2tree(Object obj, int depth) {
        HashSet collectedObjects = new HashSet();
        return TreeStructureUtil.object2tree("[ROOT]", obj, depth, collectedObjects);
    }

    private static TreeStructure object2tree(String fieldName, Object current, int depth, HashSet collectedObjects) {
        Field[] fields = current.getClass().getFields();
        LinkedList<Object> currentFields = new LinkedList<Object>();
        int i = 0;
        while (i < fields.length) {
            block27: {
                String name = fields[i].getName();
                Object obj = null;
                try {
                    fields[i].setAccessible(true);
                    obj = fields[i].get(current);
                }
                catch (IllegalAccessException e) {
                    System.err.println("IllegalAccessException:" + name + ":" + fields[i].isAccessible());
                    currentFields.add("X:" + name + ":" + fields[i].getDeclaringClass().getName());
                    break block27;
                }
                if (obj == null) {
                    currentFields.add(name + ":null");
                } else if (collectedObjects.contains(obj)) {
                    currentFields.add(name + ":ref=" + obj.getClass().getName() + "(" + obj.hashCode() + ")");
                } else if (!(obj instanceof Class)) {
                    if (obj.getClass().equals(Integer.TYPE) || obj instanceof Integer) {
                        currentFields.add(name + ":int:" + (Integer)obj);
                    } else if (obj.getClass().equals(Double.TYPE) || obj instanceof Double) {
                        currentFields.add(name + ":double:" + (Double)obj);
                    } else if (obj.getClass().equals(Float.TYPE) || obj instanceof Float) {
                        currentFields.add(name + ":float:" + ((Float)obj).floatValue());
                    } else if (obj.getClass().equals(Long.TYPE) || obj instanceof Long) {
                        currentFields.add(name + ":long:" + (Long)obj);
                    } else if (obj.getClass().equals(Boolean.TYPE) || obj instanceof Boolean) {
                        currentFields.add(name + ":boolean:" + (Boolean)obj);
                    } else if (obj.getClass().equals(Byte.TYPE) || obj instanceof Byte) {
                        currentFields.add(name + ":byte:" + (Byte)obj);
                    } else if (obj.getClass().equals(Short.TYPE) || obj instanceof Short) {
                        currentFields.add(name + ":short:" + (Short)obj);
                    } else if (obj instanceof String) {
                        currentFields.add(name + ":" + (String)obj);
                    } else {
                        collectedObjects.add(obj);
                        if (depth == 0) {
                            currentFields.add(name + ":" + obj.getClass().getName() + "...");
                        } else {
                            currentFields.add(TreeStructureUtil.object2tree(name, obj, depth - 1, collectedObjects));
                        }
                    }
                }
            }
            ++i;
        }
        TreeStructure[] branch = new TreeStructure[currentFields.size()];
        int i2 = 0;
        while (i2 < branch.length) {
            Object obj = currentFields.get(i2);
            branch[i2] = obj instanceof String ? new TreeStructureClass((String)obj) : (TreeStructure)obj;
            ++i2;
        }
        return new TreeStructureClass(fieldName + ":" + current.getClass().getName() + "(" + current.hashCode() + ")", branch);
    }

    public static TreeStructure getTestTreeObject(int num) {
        Integer[] numbers = new Integer[num];
        int i = 0;
        while (i < num) {
            numbers[i] = new Integer(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < num * 2) {
            int i22;
            int i1 = (int)(Math.random() * (double)num);
            if (i1 != (i22 = (int)(Math.random() * (double)num))) {
                Integer t = numbers[i1];
                numbers[i1] = numbers[i22];
                numbers[i22] = t;
            }
            ++i2;
        }
        NumberNode root = new NumberNode(numbers[0]);
        int i3 = 1;
        while (i3 < num) {
            root.add(numbers[i3]);
            ++i3;
        }
        return root;
    }

    static class NumberNode
    implements TreeStructure {
        private Integer number;
        private NumberNode small;
        private NumberNode large;

        NumberNode(Integer n) {
            this.number = n;
        }

        void add(Integer n) {
            if (this.number.compareTo(n) < 0) {
                if (this.large == null) {
                    this.large = new NumberNode(n);
                } else {
                    this.large.add(n);
                }
            } else if (this.small == null) {
                this.small = new NumberNode(n);
            } else {
                this.small.add(n);
            }
        }

        public String getTreeNodeExpression() {
            return this.number.toString();
        }

        public TreeStructure[] getTreeNodes() {
            if (this.small == null && this.large == null) {
                return null;
            }
            if (this.small != null && this.large != null) {
                return new TreeStructure[]{this.small, this.large};
            }
            if (this.small != null) {
                return new TreeStructure[]{this.small};
            }
            return new TreeStructure[]{this.large};
        }
    }
}

