/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.gr.java_conf.ccs2.comp.SwingUtil;
import jp.gr.java_conf.ccs2.core.CCSResource;

public class SelectionDialog
extends JDialog {
    protected List contents;
    protected int index = -1;
    private JLabel titleLabel;
    private JPanel jPanel1;
    private JButton okButton;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JList list;

    public SelectionDialog(Frame f, String title, List t) {
        super(f, true);
        this.initComponents();
        this.contents = t;
        this.titleLabel.setText(title);
        this.updateList();
        this.okButton.setEnabled(false);
        this.pack();
        SwingUtil.setCenter(this);
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SelectionDialog.this.closeDialog(evt);
            }
        });
        Font tf = this.titleLabel.getFont();
        this.titleLabel.setFont(tf.deriveFont((float)((double)tf.getSize2D() * 1.5)));
        BorderLayout layout = new BorderLayout();
        layout.setVgap(5);
        layout.setHgap(3);
        this.getContentPane().setLayout(layout);
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.okButton.setText(CCSResource.getResourceString("Ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText(CCSResource.getResourceString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.list.setFixedCellWidth(200);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                SelectionDialog.this.listKeyTyped(evt);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SelectionDialog.this.listValueChanged(evt);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SelectionDialog.this.listMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    private void listKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.onOk();
        }
    }

    private void listValueChanged(ListSelectionEvent evt) {
        this.okButton.setEnabled(true);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.onOk();
    }

    private void listMouseClicked(MouseEvent evt) {
        this.okButton.setEnabled(true);
        if (evt.getClickCount() == 2) {
            this.onOk();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        LinkedList<String> t = new LinkedList<String>();
        t.add("first");
        t.add("second");
        t.add("third");
        SelectionDialog dlg = new SelectionDialog((Frame)new JFrame(), "Dialog test", t);
        dlg.show();
        if (dlg.getIndex() != -1) {
            System.out.println(t.get(dlg.getIndex()));
        } else {
            System.out.println("canceled");
        }
    }

    void updateList() {
        Object[] array = this.contents.toArray();
        this.list.setListData(array);
    }

    public void onOk() {
        int i = this.list.getSelectedIndex();
        if (i < 0 && i >= this.contents.size()) {
            JOptionPane.showMessageDialog(this, CCSResource.getResourceString("Please_select_an_item."));
            return;
        }
        this.index = i;
        this.dispose();
    }

    public int getIndex() {
        return this.index;
    }
}

