/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.comp;

import ccs.comp.d3.Renderer;
import ccs.comp.d3.RendererComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class SwingRendererComponent
extends JComponent
implements RendererComponent {
    private Rectangle paintRegion;
    private Renderer renderer;
    private Dimension lastSize;

    public SwingRendererComponent(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.paintRegion = new Rectangle(0, 0, width, height);
    }

    public void repaintOrder() {
        this.repaint();
    }

    public void onResizeCanvas() {
        Dimension d = this.getSize();
        if (d == null) {
            return;
        }
        this.paintRegion = new Rectangle(0, 0, d.width, d.height);
        if (this.renderer == null) {
            return;
        }
        this.renderer.updatePaintRegion();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        if (d == null) {
            return;
        }
        if (d.width != this.paintRegion.width || d.height != this.paintRegion.height) {
            this.paintRegion = new Rectangle(0, 0, d.width, d.height);
            if (this.renderer == null) {
                return;
            }
            this.renderer.updatePaintRegion();
        }
        this.renderer.paint(g);
    }

    public Rectangle getPaintRegion() {
        return this.paintRegion;
    }

    public Component getComponent() {
        return this;
    }
}

