/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.core;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jp.gr.java_conf.ccs2.core.AppConfig;
import jp.gr.java_conf.ccs2.util.ResourceFile;

public class DefaultAppConfig
extends AppConfig {
    protected static String separator = ":";
    private HashMap table = new HashMap();
    private List fileList = new LinkedList();

    public DefaultAppConfig(String defaultsUri, String propFile, String[] args) {
        this.setupDefaults(defaultsUri);
        this.setupFile(propFile);
        this.setupArgs(args);
    }

    public DefaultAppConfig(String propFile, String[] args) {
        this(null, propFile, args);
    }

    public DefaultAppConfig(String[] args) {
        this(null, args);
    }

    protected void setupDefaults(String prop) {
        if (prop == null) {
            return;
        }
        try {
            this.setupProp(ResourceBundle.getBundle(prop));
        }
        catch (MissingResourceException e) {}
    }

    protected void setupFile(String propFile) {
        if (propFile == null) {
            return;
        }
        File file = new File(propFile);
        if (!file.exists()) {
            return;
        }
        this.setupProp(ResourceFile.getResourceFile(propFile));
    }

    protected void setupProp(ResourceBundle res) {
        if (res == null) {
            return;
        }
        Enumeration<String> keys = res.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            try {
                String cont = res.getString(key);
                this.setOption(key, cont);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
    }

    private void setOption(String key, String content) {
        if (content.equalsIgnoreCase("true") || content.equalsIgnoreCase("yes")) {
            this.table.put(key, Boolean.TRUE);
        } else if (content.equalsIgnoreCase("false") || content.equalsIgnoreCase("no")) {
            this.table.put(key, Boolean.FALSE);
        } else {
            this.table.put(key, content);
        }
    }

    protected void setupArgs(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) != '-') {
                this.fileList.add(args[i]);
            } else {
                int ps = args[i].indexOf(separator);
                if (ps == -1) {
                    this.table.put(args[i].substring(1), Boolean.TRUE);
                } else {
                    this.setOption(args[i].substring(1, ps), args[i].substring(ps + 1));
                }
            }
            ++i;
        }
    }

    public String[] getArgumentFiles() {
        String[] rets = new String[this.fileList.size()];
        return this.fileList.toArray(rets);
    }

    public String[] getOptionKeys() {
        String[] ret = new String[this.table.size()];
        Iterator keys = this.table.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            ret[i++] = key;
        }
        return ret;
    }

    protected Object getOptionObject(String key) {
        return this.table.get(key);
    }
}

