/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.core;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import jp.gr.java_conf.ccs2.core.AppConfig;
import jp.gr.java_conf.ccs2.core.MessageMonitor;
import jp.gr.java_conf.ccs2.util.FileRotator;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class DefaultMonitor
implements MessageMonitor {
    private static String separator = System.getProperty("line.separator");
    private String logFileName;
    private PrintStream out;
    private String encoding;
    private FileRotator rotator;
    private int debugFlushLevel = 4;
    private int debugRecordNumber = 0;
    private LinkedList debugList = new LinkedList();
    private int logLevel = 2;
    private String format = "%date%|%level%|%message%";
    private String[] filters;
    private DateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final String defaultName = "ccslog.txt";
    protected static MessageMonitor defaultMonitor;

    public DefaultMonitor(String filename, int logLevel, PrintStream out) {
        this.setLogFile(filename);
        if (logLevel < 0 || logLevel > 4) {
            logLevel = 2;
        }
        this.logLevel = logLevel;
        this.out = out;
    }

    public DefaultMonitor() {
        this(null, 2, System.out);
    }

    public DefaultMonitor(int logLevel) {
        this(null, logLevel, System.out);
    }

    public DefaultMonitor(String filename) {
        this(filename, 2, null);
    }

    public DefaultMonitor(AppConfig config) {
        this.setLogFile(config.getOptionString("logfile"));
        if (this.logFileName == null) {
            this.out = System.out;
        }
        this.setLogLevel(config.getOptionString("logLevel"));
        this.setFilters(config.getOptionString("logFilters"));
        this.setEncoding(config.getOptionString("logEncoding"));
    }

    public void setDebugFlushLevel(int a) {
        if (a > 0 && a <= 4) {
            this.debugFlushLevel = a;
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDebugRecordNumber(int i) {
        if (i >= 0) {
            this.debugRecordNumber = i;
        }
    }

    public void setRotator(FileRotator rotator) {
        this.rotator = rotator;
        rotator.setFilename(this.logFileName);
    }

    public void setLogFile(String filename) {
        if (!StringUtil.isNull(filename)) {
            this.logFileName = filename;
            if (this.rotator != null) {
                this.rotator.setFilename(filename);
            }
        }
    }

    public void setDateFormatter(DateFormat df) {
        this.dateFormatter = df;
    }

    public void setFilters(String args) {
        if (StringUtil.isNull(args)) {
            return;
        }
        this.setFilters(StringUtil.split(args));
    }

    public void setFilters(String[] args) {
        this.filters = args;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int a) {
        if (a >= 0 && a <= 4) {
            this.logLevel = a;
        }
    }

    public void setLogLevel(String in) {
        int i = 0;
        while (i < MessageMonitor.LEVELS.length) {
            if (MessageMonitor.LEVELS[i].equalsIgnoreCase(in)) {
                this.setLogLevel(i);
                return;
            }
            ++i;
        }
        this.setLogLevel(2);
    }

    public PrintStream getOutput() {
        return this.out;
    }

    public void setOutput(PrintStream p) {
        this.out = p;
    }

    public void setFormat(String f) {
        this.format = f;
    }

    public String toString() {
        String ret = "CLASS:" + this.getClass().getName() + "\n";
        ret = ret + "OUTPUT:" + (this.getOutput() != null ? this.getOutput().getClass().getName() : null) + "\n";
        ret = ret + "LOGFILE:" + this.logFileName + "\n";
        ret = ret + "STATE:" + MessageMonitor.LEVELS[this.getLogLevel()];
        return ret;
    }

    public void debug(String message) {
        this.message(message, 0);
    }

    public void verbose(String message) {
        this.message(message, 1);
    }

    public void normal(String message) {
        this.message(message, 2);
    }

    public void warning(String message) {
        this.message(message, 3);
    }

    public void error(String message) {
        this.message(message, 4);
    }

    public void debugStackTrace(String message) {
        if (this.blockRecording(message)) {
            return;
        }
        Throwable t = new Throwable("DEBUG trace");
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        sw.flush();
        String trace = sw.toString() + "\n";
        this.message(message + trace, 0);
    }

    public void recordStackTrace(Throwable t) {
        String trace = "";
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        sw.flush();
        trace = sw.toString();
        this.message(trace, 4);
    }

    protected boolean blockRecording(String message) {
        if (this.filters != null && this.filters.length != 0) {
            int i = 0;
            while (i < this.filters.length) {
                if (message.indexOf(this.filters[i]) != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected synchronized void message(String message, int level) {
        block10: {
            if (this.logLevel > level) {
                if (this.debugRecordNumber > 0) {
                    this.debugList.add(this.formatMessage(message, level));
                    while (this.debugList.size() > this.debugRecordNumber) {
                        this.debugList.removeFirst();
                    }
                }
                return;
            }
            if (this.blockRecording(message)) {
                return;
            }
            String er = this.formatMessage(message, level);
            if (this.out != null) {
                this.out.println(er);
            }
            if (this.logFileName == null) break block10;
            try {
                BufferedWriter logFile = null;
                logFile = StringUtil.isNull(this.encoding) ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.logFileName, true))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFileName, true), this.encoding));
                logFile.write(er + separator);
                if (level >= this.debugFlushLevel && this.debugRecordNumber > 0 && this.debugList.size() > 0) {
                    logFile.write("===(Debug record begin)===" + separator);
                    while (this.debugList.size() > 0) {
                        logFile.write(this.debugList.removeFirst() + separator);
                    }
                    logFile.write("===(Debug record end)=====" + separator);
                }
                ((Writer)logFile).flush();
                ((Writer)logFile).close();
                if (this.rotator != null) {
                    this.rotator.rotate();
                }
            }
            catch (IOException e) {
                System.err.println("fatal error : IOException at DefualtMonitor.");
                System.err.println(er);
            }
        }
    }

    private String formatMessage(String message, int level) {
        String ret = StringUtil.replace(this.format, "%level%", MessageMonitor.LEVELS[level]);
        ret = StringUtil.replace(ret, "%date%", this.dateFormatter.format(new Date()));
        return StringUtil.replace(ret, "%message%", message);
    }

    protected static MessageMonitor getDefaultMonitor() {
        if (defaultMonitor == null) {
            defaultMonitor = new DefaultMonitor(defaultName, 2, System.out);
        }
        return defaultMonitor;
    }

    public static void errorLog(String message) {
        DefaultMonitor.getDefaultMonitor().error(message);
    }

    public static void warningLog(String message) {
        DefaultMonitor.getDefaultMonitor().warning(message);
    }

    public static void messageLog(String message) {
        DefaultMonitor.getDefaultMonitor().normal(message);
    }
}

