/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.core;

import java.io.File;
import java.text.MessageFormat;

public class LogRotator {
    private String logFile;
    private long logSize;
    private int logNumber;
    private static final String FILE_FORMAT = "{0}.{1}";

    public LogRotator(String logFile, long logSize, int logNumber) {
        this.logFile = logFile;
        this.logSize = logSize;
        this.logNumber = logNumber;
    }

    public void setFileName(String path) {
        this.logFile = path;
    }

    public void rotate() {
        File file = new File(this.logFile);
        if (!file.exists() || this.logSize < 1L || this.logNumber < 1) {
            return;
        }
        if (file.length() >= this.logSize) {
            this.moveOldFiles();
        }
    }

    private void moveOldFiles() {
        Object[] args = new String[2];
        args[0] = this.logFile;
        int i = this.logNumber;
        while (i >= 0) {
            File file = null;
            if (i > 0) {
                args[1] = Integer.toString(i);
                file = new File(MessageFormat.format(FILE_FORMAT, args));
            } else {
                file = new File(this.logFile);
            }
            if (file.exists()) {
                if (i == this.logNumber) {
                    file.delete();
                } else {
                    args[1] = Integer.toString(i + 1);
                    File nextFile = new File(MessageFormat.format(FILE_FORMAT, args));
                    file.renameTo(nextFile);
                }
            }
            --i;
        }
    }
}

