/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.io;

import java.io.BufferedReader;
import java.io.IOException;

public abstract class AbstractReader {
    protected BufferedReader input;

    protected AbstractReader(BufferedReader in) {
        this.input = in;
    }

    public boolean isOk() {
        if (this.input == null) {
            return false;
        }
        try {
            return this.input.ready();
        }
        catch (IOException e) {
            System.err.println("IOException in AbstractReader.isOk()");
            e.printStackTrace();
            return false;
        }
    }

    public BufferedReader getReader() {
        return this.input;
    }

    public void close() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            System.err.println(" I/O exception durin closing in AbstractReader.close");
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean isEOF() {
        try {
            return !this.input.ready();
        }
        catch (IOException e) {
            System.err.println(" I/O exception during EOF check in AbstractReader.isEOF");
            throw new RuntimeException(e.getMessage());
        }
    }

    public String read() {
        try {
            return this.input.readLine();
        }
        catch (IOException e) {
            System.err.println(" I/O Exception during reading a line in AbstractReader.read");
            throw new RuntimeException(e.getMessage());
        }
    }

    public int readInteger() {
        try {
            return Integer.parseInt(this.read());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long readLong() {
        try {
            return Long.parseLong(this.read());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public double readDouble() {
        try {
            return Double.valueOf(this.read());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String read(String def) {
        try {
            return this.input.readLine();
        }
        catch (IOException e) {
            System.err.println(" I/O Exception during reading a line in AbstractReader.");
            return def;
        }
    }

    public int readInteger(int def) {
        try {
            return Integer.parseInt(this.read());
        }
        catch (Exception e) {
            return def;
        }
    }

    public long readLong(long def) {
        try {
            return Long.parseLong(this.read());
        }
        catch (Exception e) {
            return def;
        }
    }

    public double readDouble(double def) {
        try {
            return Double.valueOf(this.read());
        }
        catch (Exception e) {
            return def;
        }
    }
}

