/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class EasyWriter {
    protected PrintWriter out;

    private EasyWriter() {
    }

    public EasyWriter(String filename) {
        this(filename, null);
    }

    public EasyWriter(String filename, String encoding) {
        this.out = EasyWriter.openOutput(filename, encoding);
    }

    public boolean isOk() {
        return this.out != null;
    }

    public void close() {
        this.out.flush();
        this.out.close();
    }

    public void flush() {
        this.out.flush();
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public void println(String a) {
        this.out.println(a);
    }

    public void print(String a) {
        this.out.print(a);
    }

    public static PrintWriter openOutput(String filename, String encoding) {
        if (StringUtil.isNull(encoding)) {
            encoding = System.getProperty("file.encoding");
        }
        if (filename == null || filename.equals("")) {
            System.out.println("*** null filename. ***");
            return null;
        }
        PrintWriter tout = null;
        try {
            tout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), encoding));
        }
        catch (IOException e) {
            System.out.println("*** I/O Exception was occured. ****");
        }
        return tout;
    }

    public static void main(String[] args) {
        EasyWriter file = new EasyWriter("test1");
        file.println("hello world");
        if (args.length != 0) {
            int i = 0;
            while (i < args.length) {
                file.println(args[i]);
                ++i;
            }
        }
        file.println("ok.");
        file.flush();
    }
}

