/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.sql.db;

import java.sql.SQLException;
import java.sql.Statement;
import jp.gr.java_conf.ccs2.sql.JDBCUtil;
import jp.gr.java_conf.ccs2.sql.NativeDBCommand;

public class PostgreSQLCommand
implements NativeDBCommand {
    public String getDBName() {
        return "PostgreSQL";
    }

    public void lockTables(Statement stmt, String[] tables, boolean writeLock) throws SQLException {
        if (tables == null || tables.length == 0) {
            return;
        }
        boolean[] ls = new boolean[tables.length];
        int i = 0;
        while (i < tables.length) {
            ls[i] = writeLock;
            ++i;
        }
        this.lockTables(stmt, tables, ls);
    }

    public void lockTables(Statement stmt, String[] tables, boolean[] writeLock) throws SQLException {
        if (tables == null || tables.length == 0) {
            return;
        }
        int i = 0;
        while (i < tables.length) {
            String sql = "LOCK TABLE ";
            sql = sql + tables[i];
            sql = writeLock[i] ? sql + " IN ACCESS EXCLUSIVE MODE" : sql + " IN ACCESS SHARE MODE";
            stmt.executeUpdate(sql);
            ++i;
        }
    }

    public void unlockTables(Statement stmt, String[] tables) throws SQLException {
    }

    public String escape(String text) {
        return JDBCUtil.defaultEscape(text);
    }
}

