/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CacheHashMap
implements Map {
    private HashMap referenceCache = new HashMap();
    private LinkedList keyList = new LinkedList();
    private int maxSize = 0;

    public CacheHashMap(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public void setMaxSize(int sz) {
        this.maxSize = sz;
        this.clear();
    }

    public void clear() {
        this.keyList.clear();
        this.referenceCache.clear();
    }

    private void refresh() {
        Iterator it = this.keyList.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            SoftReference wr = (SoftReference)this.referenceCache.get(key);
            Object obj = wr.get();
            if (obj != null) continue;
            it.remove();
            this.referenceCache.remove(key);
        }
    }

    public boolean containsKey(Object key) {
        this.refresh();
        return this.referenceCache.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.refresh();
        Iterator it = this.keyList.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            SoftReference wr = (SoftReference)this.referenceCache.get(key);
            Object obj = wr.get();
            if (obj == null || !value.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        Iterator it = this.keyList.iterator();
        TreeSet<SoftEntry> set = new TreeSet<SoftEntry>();
        while (it.hasNext()) {
            Object key = it.next();
            SoftReference wr = (SoftReference)this.referenceCache.get(key);
            set.add(new SoftEntry(key, wr));
        }
        return set;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public Object get(Object key) {
        SoftReference wr = (SoftReference)this.referenceCache.get(key);
        if (wr == null) {
            return null;
        }
        Object obj = wr.get();
        if (obj == null) {
            this.remove(key);
            return null;
        }
        this.keyList.remove(key);
        this.keyList.addFirst(key);
        return obj;
    }

    public boolean isEmpty() {
        this.refresh();
        return this.keyList.isEmpty();
    }

    public Set keySet() {
        this.refresh();
        return this.referenceCache.keySet();
    }

    public Object put(Object key, Object value) {
        while (this.keyList.size() >= this.maxSize) {
            Object lk = this.keyList.removeLast();
            this.referenceCache.remove(lk);
        }
        this.keyList.addFirst(key);
        SoftReference<Object> wr = new SoftReference<Object>(value);
        SoftReference<Object> lwr = this.referenceCache.put(key, wr);
        if (lwr != null) {
            return lwr.get();
        }
        return null;
    }

    public void putAll(Map t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    public Object remove(Object key) {
        this.keyList.remove(key);
        SoftReference wr = (SoftReference)this.referenceCache.remove(key);
        return wr.get();
    }

    public int size() {
        this.refresh();
        return this.keyList.size();
    }

    public Collection values() {
        Iterator it = this.referenceCache.entrySet().iterator();
        LinkedList set = new LinkedList();
        while (it.hasNext()) {
            SoftReference wr = (SoftReference)((Object)it.next());
            Object obj = wr.get();
            if (obj == null) continue;
            set.add(obj);
        }
        return set;
    }

    public static void main(String[] args) {
        CacheHashMap map = new CacheHashMap(4);
        Integer i0 = new Integer(0);
        map.put(i0, new Integer(100));
        Integer i1 = new Integer(1);
        map.put(i1, new Integer(200));
        map.put(new Integer(2), new Integer(300));
        map.put(new Integer(3), new Integer(400));
        System.out.println("size:" + map.size());
        System.out.println("0:" + map.get(new Integer(0)));
        map.put(new Integer(4), new Integer(500));
        System.out.println("1:" + map.get(i1));
        System.gc();
        System.out.println("size:" + map.size());
    }

    class SoftEntry
    implements Map.Entry {
        private SoftReference ref;
        private Object key;

        SoftEntry(Object tkey, SoftReference wr) {
            this.key = tkey;
            this.ref = wr;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.ref.get();
        }

        public Object setValue(Object value) {
            throw new InternalError("Not supported operation.");
        }
    }
}

