/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtil {
    static DateFormat ftj_date = DateFormat.getDateInstance(0);
    static DateFormat ftj_datetime = DateFormat.getDateTimeInstance(0, 0);
    static DateFormat ftl_date = DateFormat.getDateInstance(2);
    static DateFormat ftl_datetime = DateFormat.getDateTimeInstance(2, 2);
    static int windowSize = 16;
    private static ResourceBundle resources;
    private static boolean loadFailed;

    public static String datej(Date d) {
        if (d == null) {
            return "";
        }
        return ftj_date.format(d);
    }

    public static String dateTimej(Date d) {
        if (d == null) {
            return "";
        }
        return ftj_datetime.format(d);
    }

    public static String datel(Date d) {
        if (d == null) {
            return "";
        }
        return ftl_date.format(d);
    }

    public static String dateTimel(Date d) {
        if (d == null) {
            return "";
        }
        return ftl_datetime.format(d);
    }

    public static final boolean isNull(String s) {
        return s == null || s.length() == 0;
    }

    public static final boolean equalsIgnoreSpace(String a, String b) {
        try {
            return StringUtil.assertEqualsIgnoreSpace(a, b);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static final boolean assertEqualsIgnoreSpace(String a, String b) {
        block4: {
            int bb;
            int aa;
            if (a.equals(b)) {
                return true;
            }
            int ac = 0;
            int bc = 0;
            do {
                aa = 32;
                bb = 32;
                while (ac < a.length()) {
                    aa = a.charAt(ac);
                    ++ac;
                    if (aa == 32 || aa == 9 || aa == 10 || aa == 13) continue;
                }
                while (bc < b.length()) {
                    bb = b.charAt(bc);
                    ++bc;
                    if (bb == 32 || bb == 9 || bb == 10 || bb == 13) continue;
                }
                if (ac >= a.length() && bc >= b.length()) break block4;
            } while (aa == bb);
            String ret = "ASSERT String (ignore space) :\n";
            ret = ret + StringUtil.makeErrorMessage(a, ac - 1) + "\n";
            ret = ret + StringUtil.makeErrorMessage(b, bc - 1);
            throw new RuntimeException(ret);
        }
        return true;
    }

    public static final boolean assertEquals(String a, String b) {
        if (a.equals(b)) {
            return true;
        }
        int rows = 0;
        int cols = 0;
        int i = 0;
        while (i < Math.min(a.length(), b.length())) {
            if (a.charAt(i) != b.charAt(i)) {
                String ret = "ASSERT String rows[" + rows + "] cols[" + cols + "]:\n";
                ret = ret + StringUtil.makeErrorMessage(a, i);
                ret = ret + "\n" + StringUtil.makeErrorMessage(b, i);
                throw new RuntimeException(ret);
            }
            if (a.charAt(i) == '\n') {
                cols = 0;
                ++rows;
            } else {
                ++cols;
            }
            ++i;
        }
        if (a.length() != b.length()) {
            throw new RuntimeException("Length different : left[" + a.length() + "] : right[" + b.length() + "]");
        }
        return false;
    }

    private static String makeErrorMessage(String in, int pos) {
        String message = "{0}[{1}]{2}";
        Object[] args1 = new Object[]{in.substring(Math.max(0, pos - windowSize), pos), in.substring(pos, pos + 1), in.substring(pos + 1, Math.min(in.length(), pos + windowSize))};
        return MessageFormat.format(message, args1);
    }

    public static String conbine(Object[] ss) {
        String[] args = new String[ss.length];
        int i = 0;
        while (i < args.length) {
            args[i] = ss[i].toString();
            ++i;
        }
        return StringUtil.conbine(args, "");
    }

    public static String conbine(String[] ss) {
        return StringUtil.conbine(ss, "");
    }

    public static String conbine(String[] ss, String spliter) {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < ss.length) {
            ret.append(ss[i]).append(spliter);
            ++i;
        }
        if (ss.length == 0) {
            return ret.toString();
        }
        return ret.toString().substring(0, ret.length() - spliter.length());
    }

    public static String[] split(String arg) {
        return StringUtil.split(arg, null);
    }

    public static String[] split(String arg, String dlm) {
        String[] rets = null;
        if (arg == null) {
            return null;
        }
        if (arg.length() == 0) {
            rets = new String[]{""};
            return rets;
        }
        if (dlm != null) {
            Vector<String> list = new Vector<String>();
            int skip = dlm.length();
            int sx = 0;
            while (true) {
                int ps;
                if ((ps = arg.indexOf(dlm, sx)) == 0) {
                    list.addElement("");
                } else {
                    if (ps == -1) break;
                    if (arg.charAt(ps - 1) == '\\') {
                        String tmp = arg.substring(0, ps - 1) + arg.substring(ps);
                        sx = ps + skip - 1;
                        arg = tmp;
                        continue;
                    }
                    list.addElement(arg.substring(0, ps));
                }
                arg = arg.substring(ps + skip);
                sx = 0;
            }
            list.addElement(arg);
            rets = new String[list.size()];
            int i = 0;
            while (i < rets.length) {
                rets[i] = ((String)list.elementAt(i)).trim();
                ++i;
            }
            return rets;
        }
        StringTokenizer st = null;
        st = dlm == null ? new StringTokenizer(arg) : new StringTokenizer(arg, dlm);
        rets = new String[st.countTokens()];
        int i = 0;
        while (i < rets.length) {
            rets[i] = st.nextToken();
            ++i;
        }
        return rets;
    }

    public static String escape(String in, char[] orgChars, String[] replaceChars) {
        if (in == null || orgChars == null || replaceChars == null || orgChars.length == 0 || replaceChars.length == 0) {
            return in;
        }
        int i = 0;
        while (i < orgChars.length) {
            if (in.indexOf(orgChars[i]) != -1) {
                in = StringUtil.replace(in, String.valueOf(orgChars[i]), replaceChars[i]);
            }
            ++i;
        }
        return in;
    }

    public static String replace(String in, String target, String after) {
        if (in == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        while (true) {
            int ps;
            if ((ps = in.indexOf(target)) == -1) break;
            out.append(in.substring(0, ps));
            out.append(after);
            in = in.substring(ps + target.length());
        }
        out.append(in.toString());
        return out.toString();
    }

    public static String transformZenkakuToHankaku(String in) {
        if (in == null) {
            return null;
        }
        String zenkaku = StringUtil.getResourceString("zenkaku");
        String hankaku = StringUtil.getResourceString("hankaku");
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char a = in.charAt(i);
            int ps = zenkaku.indexOf(a);
            if (ps == -1) {
                ret.append(a);
            } else {
                ret.append(hankaku.charAt(ps));
            }
            ++i;
        }
        return ret.toString();
    }

    public static String transformHankakuToZenkaku(String in) {
        if (in == null) {
            return null;
        }
        String zenkaku = StringUtil.getResourceString("zenkaku");
        String hankaku = StringUtil.getResourceString("hankaku");
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char a = in.charAt(i);
            int ps = hankaku.indexOf(a);
            if (ps == -1) {
                ret.append(a);
            } else {
                ret.append(zenkaku.charAt(ps));
            }
            ++i;
        }
        return ret.toString();
    }

    public static String throw2string(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        sw.flush();
        return sw.toString();
    }

    public static String stringDump(String in) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            sb.append(c).append(" : ");
            sb.append(Integer.toHexString(c));
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static String dumpBinData(byte[] array) {
        StringBuffer sb = new StringBuffer("====(binary dump)======\n");
        int i = 0;
        while (i < array.length / 8) {
            int j = 0;
            while (j < 8) {
                String hex;
                int a = array[j + i * 8];
                if (a < 0) {
                    a = 256 + a;
                }
                if ((hex = Integer.toHexString(a)).length() < 2) {
                    hex = "0" + hex;
                }
                sb.append(hex + " ");
                ++j;
            }
            sb.append(" |");
            try {
                sb.append(new String(array, i * 8, 8, "SJIS"));
            }
            catch (UnsupportedEncodingException e) {
                sb.append(new String(array, i * 8, 8));
            }
            sb.append("|\n");
            ++i;
        }
        sb.append("====================");
        return sb.toString();
    }

    public static byte[] str2byte(String in) {
        if (StringUtil.isNull(in)) {
            return null;
        }
        if (in.length() % 2 != 0) {
            return null;
        }
        byte[] code = new byte[in.length() / 2];
        try {
            int i = 0;
            while (i < code.length) {
                String a = in.substring(i * 2, i * 2 + 2);
                code[i] = (byte)(0xFF & Integer.parseInt(a, 16));
                ++i;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return code;
    }

    public static String byte2str(byte[] code) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < code.length) {
            int v = 0xFF & code[i];
            String a = "00" + Integer.toHexString(v);
            sb.append(a.substring(a.length() - 2, a.length()));
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        StringUtil.assertEquals(StringUtil.transformZenkakuToHankaku("This is a pen which \uff29 had.\nThank you \uff56ery mu\uff43h\uff0e"), "This is a pen which I had.\nThank you very much.");
        StringUtil.assertEquals(StringUtil.transformHankakuToZenkaku("This is a pen which I had."), "\uff34\uff48\uff49\uff53\u3000\uff49\uff53\u3000\uff41\u3000\uff50\uff45\uff4e\u3000\uff57\uff48\uff49\uff43\uff48\u3000\uff29\u3000\uff48\uff41\uff44\uff0e");
    }

    private static void loadResources() {
        try {
            resources = ResourceBundle.getBundle("jp.gr.java_conf.ccs2.util.zenkaku");
        }
        catch (MissingResourceException mre) {
            System.err.println("[strings.properties] not found");
            loadFailed = true;
        }
    }

    private static String getResourceString(String s) {
        if (resources == null && !loadFailed) {
            StringUtil.loadResources();
        }
        try {
            return resources.getString(s);
        }
        catch (RuntimeException e) {
            System.err.println("no string :" + s);
            return s;
        }
    }

    static {
        loadFailed = false;
    }
}

