import java.util.ArrayList;
import java.util.HashMap;
import jp.gr.java_conf.ccs2.core.MessageMonitor;


public class ClassFinder {

	private HashMap cacheTable = new HashMap();
	private ArrayList importList = new ArrayList();
	private MessageMonitor monitor;	
	
	public ClassFinder(MessageMonitor m) {
		monitor = m;
		importList.add("java.lang.");
	}

	public void addImport(String line) {
		String[] lines = line.split(",");
		for(int i=0;i<lines.length;i++) {
			String ai = lines[i];
			if (!importList.contains(ai)) {
				if (ai.endsWith("*")) {
					ai = ai.substring(0,ai.length()-1);
				}
				importList.add(0,ai);
				monitor.verbose("ClassFinder: import : "+ai);
			}
		}
		cacheTable.clear();
	}

	public Class findClass(String cn) throws ClassNotFoundException {
		Class ret = getClass(cn);
		if (ret != null) return ret;
		
		ret = (Class)cacheTable.get(cn);
		if (ret != null) return ret;

		for(int i=0;i<importList.size();i++) {
			String prefix = (String)importList.get(i);
			if (prefix.endsWith(".")) {
				String fqcn = prefix+cn;
				monitor.debug("ClassFinder: try : "+fqcn);
				ret = getClass(fqcn);
			} else if (prefix.endsWith(cn)) {
				ret = getClass(prefix);
			} else {
				continue;
			}
			if (ret != null) {
				cacheTable.put(cn,ret);
				return ret;
			}
		}
		throw new ClassNotFoundException("Not found class: "+cn);
	}

	public String fqcn(String cn) throws ClassNotFoundException {
		return findClass(cn).getName();
	}

	private Class getClass(String fqcn) {
		try {
			return Class.forName(fqcn);
		} catch (ClassNotFoundException e) {
			return null;
		}
	}
	

}