import java.io.IOException;
import jp.gr.java_conf.ccs2.core.*;
import org.apache.xmlrpc.XmlRpc;


public class JavaBridge extends AppContextClass {

	public static void main(String[] args) {
		if (args.length == 1 && "-h".equals(args[0])) {
			printHelp();
			return;
		}
		try {
			new JavaBridge(args).start();
		} catch (IOException e) {
			e.printStackTrace();
			errorExit(e.getClass().getName()+" : "+e.getMessage());
		}
	}

	private static void errorExit(String message) {
		System.err.println("Startup failed. : "+message);
		System.exit(0);
	}

	protected JavaBridge(String [] args) {
		super(args);
		((DefaultMonitor)getMonitor()).setFormat(MessageMonitor.FORMAT_MESSAGE);
	}

	protected void start() throws IOException {
		getMonitor().debug("Start main routine.");
		startupServer();
		System.out.println("OK.");
	}

	private void startupServer() throws IOException {
		XmlRpc.setEncoding("UTF-8");
		try {
			XmlRpc.setDriver("xerces");
		} catch (Exception e) {
			getMonitor().recordStackTrace(e);
		}
		String rhost = getConfig().getOptionString("remotehost","localhost");
		int rport = getConfig().getOptionInteger("remoteport",9009);
		IOverridedRMI rmi = new XMLRPC_OverridedRMI(rhost,rport);
		BridgeServer server = new BridgeServer(getMonitor(),rmi);
		int port = getConfig().getOptionInteger("javaport",9010);
		XMLRPC_JBServer front = new XMLRPC_JBServer(port,getMonitor(),server);
	}

	private static void printHelp() {
		StringBuffer sb = new StringBuffer();
		sb.append("> java JavaBridge -remotehost:localhost (client hostname)\n");
		sb.append("                  -remoteport:9009 (client service port)\n");
		sb.append("                  -javaport:9010 (my service port)");
		System.out.println(sb.toString());
	}
}