
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import jp.gr.java_conf.ccs2.core.MessageMonitor;


public class Utils {

	public static Class[] object2class(Object[] args) {
		if (args == null) return null;
		Class[] ret = new Class[args.length];
		for(int i=0;i<ret.length;i++) {
			if (args[i] == null) {
				ret[i] = null;
			} else {
				ret[i] = args[i].getClass();
			}
		}
		return ret;
	}

	public static Class primitive(Object c) {
		if (c instanceof Byte) {
			return ((Byte)c).TYPE;
		} else if (c instanceof Double) {
			return ((Double)c).TYPE;
		} else if (c instanceof Float) {
			return ((Float)c).TYPE;
		} else if (c instanceof Integer) {
			return ((Integer)c).TYPE;
		} else if (c instanceof Long) {
			return ((Long)c).TYPE;
		} else if (c instanceof Short) {
			return ((Short)c).TYPE;
		} else if (c instanceof Boolean) {
			return ((Boolean)c).TYPE;
		}
		return null;
	}

	public static Method searchPublicMethod(Class cls,String name,Object[] args) throws NoSuchMethodException {
		Method[] ms = getMethods(cls,name);
		if (ms == null || ms.length == 0) {
			throw new NoSuchMethodException("No declared method ["+name+"] in "+cls.getName()+".");
		}
		if (args == null) {
			args = new Object[0];
		}
		for(int i=0;i<ms.length;i++) {
			if (isMatched(ms[i],args)) {
				return ms[i];
			}
		}
		return cls.getMethod(name,Utils.object2class(args));//throw!
	}

	public static Method searchAllMethod(Class _cls,String name,Object[] args) throws NoSuchMethodException {
		Class cls = _cls;
		while(cls != null) {
			Method[] ms = getAllMethods(cls,ObjectManager.METHOD_ORG_PREFIX+name);
			if (ms == null || ms.length == 0) {
				//do nothing
			} else {
				if (args == null) {
					args = new Object[0];
				}
				for(int i=0;i<ms.length;i++) {
					if (isMatched(ms[i],args)) {
						return ms[i];
					}
				}
			}
			cls = cls.getSuperclass();
		}
		return _cls.getMethod(name,Utils.object2class(args));//throw!
	}

	/**
	   return non-private methods those name are the same name given name.
	*/
	private static Method[] getAllMethods(Class cls,String name) {
		Method[] ms = cls.getDeclaredMethods();
		List list = new LinkedList();
		for(int i=0;i<ms.length;i++) {
			if ( (ms[i].getModifiers() & Modifier.PRIVATE) > 0 ) continue;
			if (ms[i].getName().equals(name)) {
				list.add(ms[i]);
			}
		}
		return (Method[]) list.toArray(new Method[list.size()]);
	}

	/**
	   return public methods those name are the same name given name.
	*/
	private static Method[] getMethods(Class cls,String name) {
		Method[] ms = cls.getMethods();
		List list = new LinkedList();
		for(int i=0;i<ms.length;i++) {
			if (ms[i].getName().equals(name)) {
				list.add(ms[i]);
			}
		}
		return (Method[]) list.toArray(new Method[list.size()]);
	}

	private static boolean isMatched(Method method,Object[] args) {
		Class[] types = method.getParameterTypes();
		if (args.length != types.length) {
			return false;
		}
		if ( args.length == 0 && types.length == 0 ) {
			return true;
		}
		for (int j=0;j<args.length;j++) {
			if (!types[j].isInstance(args[j])) {
				if (types[j].isPrimitive()) {
					Class p = Utils.primitive(args[j]);
					if (p != null && types[j].equals(p)) {
						continue;
					}
				}
				Class ac = args[j].getClass();
				if (ac.equals(Integer.class) || ac.equals(Long.class)) {
					//transform the object type: int -> double,float
					if (types[j].equals(Double.TYPE) || types[j].equals(Double.class)) {
						args[j] = new Double(((Number)args[j]).doubleValue());
						continue;
					} else if (types[j].equals(Float.TYPE) || types[j].equals(Float.class)) {
						args[j] = new Float(((Number)args[j]).floatValue());
						continue;
					}
					//transform the object type: int -> short,byte
					long a = ((Number)args[j]).longValue();
					if ((types[j].equals(Short.TYPE) || 
						 types[j].equals(Short.class)) &&
						((a & 0xffff) == a)) {
						args[j] = new Short((short)a);
						continue;
					} else if ((types[j].equals(Byte.TYPE) || 
								types[j].equals(Byte.class)) && 
							   ((a & 0xff) == a)) {
						args[j] = new Byte((byte)a);
						continue;
					}
				}
				return false;
			}
		}
		return true;
	}

	public static String[] getClassInfo(Class cls) {
		List ret = new ArrayList();
		//super class
		if (cls.getSuperclass() != null) {
			ret.add("====Superclass");
			ret.add(cls.getSuperclass().getName());
		}
		ret.add("====Interfaces");
		Class[] ifs = cls.getInterfaces();
		for(int i=0;i<ifs.length;i++) {
			ret.add(ifs[i].getName());
		}
		//public method
		ret.add("====PublicMethod");
		List publicMethods = new ArrayList();
		collectMethods(cls.getDeclaredMethods(),publicMethods,true);
		ret.addAll(publicMethods);
		//protected method
		ret.add("====ProtectedMethod");
		List protectedMethod = new ArrayList();
		collectMethods(cls.getDeclaredMethods(),protectedMethod,false);
		ret.addAll(protectedMethod);
		//field
		ret.add("====Field");
		Field[] fs = cls.getDeclaredFields();
		for (int i=0;i<fs.length;i++) {
			ret.add(fs[i].getName());
		}
		return (String[])ret.toArray(new String[ret.size()]);
	}

	private static void collectMethods(Method[] ms,List list,boolean isPublic) {
		for(int i=0;i<ms.length;i++) {
			String name = ms[i].getName();
			if ((ms[i].getModifiers() & Modifier.PRIVATE)>0 ||
				ObjectManager.METHOD_SEND_MESSAGE.equals(name) || 
				ObjectManager.METHOD_SUPERCLASS_METHOD.equals(name) ||
				ObjectManager.METHOD_INJECT_FIELDS.equals(name) ||
				name.indexOf(ObjectManager.METHOD_ORG_PREFIX) == 0) {
				continue;
			}
			if ((isPublic && (ms[i].getModifiers() & Modifier.PUBLIC)>0) ||
				(!isPublic && (ms[i].getModifiers() & Modifier.PUBLIC) == 0)) {
				if (!list.contains(ms[i].getName())) {
					list.add(ms[i].getName());
				}
			}
		}
	}

}