# 
# RubyUnit test program
#   Before running this test program, you must start Java-XMLRPC server manually,
#   Ex: $ ant run-jb
# 

require 'test/unit'
require 'jbridge'

JBRIDGE_OPTIONS = {
#  :jvm_log_file => "log.txt",
#  :jvm_log_level => "debug",
#  :bridge_log => true,
  :jvm_path =>  nil,
}

include JavaBridge


class BridgeTest < Test::Unit::TestCase

  def test_normal
	p = jnew("java.awt.Point",10,20)
	assert_equal("java.awt.Point",__jclassname(p.__objectId))
	assert_equal(10,p.x)
	p.x = 20
	assert_equal(20,p.x)
	p.translate(-10,-20)
	assert_equal(10,p.x)
	assert_equal(0,p.y)
  end

  def test_static
	m = jstatic("java.lang.Math")
	assert_equal("java.lang.Class",__jclassname(m.__objectId))
	assert_equal(Math::PI, m.PI)
	assert_equal(0, m.sin(0))
  end

  def test_returnValue
	srt = jstatic("java.lang.Runtime")
	assert_equal("java.lang.Class", __jclassname(srt.__objectId))
	rt = srt.getRuntime()
	assert_equal("java.lang.Runtime", __jclassname(rt.__objectId))
  end

  def test_argument
	str = jnew("java.lang.String","10")
	assert_equal("java.lang.String",__jclassname(str.__objectId))
	it = jstatic("java.lang.Integer")
	assert_equal("java.lang.Class",__jclassname(it.__objectId))
	rt = it.parseInt(str,16)
	assert_equal(16,rt);
  end

  def test_override1
	id = jextend("java.awt.Point",10,10)
	assert_equal("java.awt.Point",__jclassname(id.__objectId))
	id.translate(10,10)
	assert_equal(20,id.x)
	assert_equal(20,id.y)

	class << id
	  def translate(dx,dy)
		self.x= self.x + dx*2
		self.y= self.y + dy*2
	  end
	end

	id.move(0,0)
	id.translate(10,20)
	assert_equal(20,id.x)
	assert_equal(40,id.y)
	
	id.move(0,0)
	id.__super__("translate",10,20)
	assert_equal(10,id.x)
	assert_equal(20,id.y)
  end

  def test_override2
	runnable = jextend("java.lang.Runnable")
	class << runnable
	  def init(t)
		@value = 0
		@thread = t
	  end
	  def result
		@value
	  end
	  def run
		sleep 0.5
		@value = 1
		@thread.wakeup
	  end
	end
	runnable.init(Thread.current)
	thread = jnew("java.lang.Thread",runnable)
	thread.start
	Thread.stop
	assert_equal(1,runnable.result)
  end

  def teardown
  end

end
