#!/usr/bin/ruby

# 
# GUI sample script: 
#       JDialog Demo (Handling the Java-AWT thread)
# 
# This script demonstrates the Java-like new method.
# 

require 'yajb/jbridge'
include JavaBridge

jimport "java.awt.*"
jimport "java.awt.event.*"
jimport "javax.swing.*"

label = jnew :JLabel, "Hello World!"

button = jnew :JButton, "open!"
action = jextend :ActionListener
button.addActionListener(action)

panel = jnew :JPanel, jnew(:GridLayout,2,1)
panel.add(label)
panel.add(button)

frame = jnew :JFrame, "JDialog DEMO"
frame.getContentPane.add(panel)
frame.pack

class << action
  def init(f,l)
	@frame = f
	@label = l
  end

  def actionPerformed(event)
	dlg = jnew :JDialog, @frame, "Modal Dialog!", true

	text = jnew :JTextField,12

	okbtn = jnew :JButton,"OK"
	action = jextend :ActionListener
	class << action
	  def init(d,t,l)
		@dlg = d; @text = t; @label = l
	  end
	  def actionPerformed(e)
		@label.setText(@text.getText())
		@dlg.dispose()
	  end
	end
	action.init(dlg,text,@label)
	okbtn.addActionListener(action)

	panel = jnew :JPanel
	panel.add(text)
	panel.add(okbtn)

	dlg.getContentPane.add(panel)
	dlg.pack
	dlg.show
  end
end

action.init(frame,label)

wc = jextend :WindowAdapter
$f = frame
class << wc
  def windowClosing(e)
	$f.dispose
	puts "Closed"
	break_bridge
	wakeup_thread
  end
end
frame.addWindowListener(wc)
frame.show()

stop_thread
