
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import javax.swing.JButton;
import jp.gr.java_conf.ccs2.core.DefaultMonitor;
import jp.gr.java_conf.ccs2.core.MessageMonitor;
import jp.gr.java_conf.ccs2.util.StringUtil;
import junit.framework.TestCase;
import java.lang.reflect.Field;


public class ObjectManagerTest extends TestCase {
	
	private ObjectManager manager;
	private SessionManager sessionManager;

	public void setUp() {
		final DefaultMonitor mon = new DefaultMonitor(MessageMonitor.DEBUG);
		mon.setFormat(MessageMonitor.FORMAT_MESSAGE);
		mon.setFilters("ClassFinder");

		IOverridedRMI broker = new IOverridedRMI() {
			public Object call(Object sid,Object objectId,String methodName,Object[] args) {
				String[] ss = new String[args.length];
				for(int i=0;i<ss.length;i++) {
					ss[i] = args[i].toString();
				}
				mon.debug("## IR.call("+sid+": "+objectId+": "+methodName+": "+StringUtil.conbine(ss, ",")+")");
				return "SUBCLASS";
			}
		};
		sessionManager = new SessionManager(mon,broker);
		manager = new ObjectManager(mon,sessionManager);
		sessionManager.init(manager);
	}

	public void testNormalObject() throws Exception {
		//test normal object.call
		Object obj = manager.getObject(manager.createObject("ObjectManagerTest",null));
		
		String ret = (String)Utils.searchPublicMethod(obj.getClass(),"sampleMethod",null).invoke(obj,null);
		assertEquals("call:","SUPERCLASS",ret);
	}

	public void testDerivedObject() throws Exception {
		//test extend object.call -> subclass (not implemented)
		Object ext = manager.getObject(manager.extendObject("ObjectManagerTest,java.awt.event.ActionListener",null));
		String ret = (String)Utils.searchPublicMethod(ext.getClass(),"sampleMethod",null).invoke(ext,null);
		assertEquals("extend_call(not impl):","SUPERCLASS",ret);
		
		//test extend object.call -> subclass (implemented)
		Field f = ext.getClass().getField(ObjectManager.FIELD_IMPL_FLAG_PREFIX+"sampleMethod");
		f.set(ext,Boolean.TRUE);
		ret = (String)Utils.searchPublicMethod(ext.getClass(),"sampleMethod",null).invoke(ext,null);
		assertEquals("extend_call(impl):","SUBCLASS",ret);

		//test extend object.call -> interface subclass 
		Object[] args = new Object[]{new ActionEvent(new JButton(),0,null)};
		ret = (String)Utils.searchPublicMethod(ext.getClass(),"actionPerformed",args).invoke(ext,args);
		assertNull("interface_call:",ret);

		//test extend object.call -> super
		Object[] args2 = new Object[]{"sampleMethod",new Object[0]};
		Method mm = Utils.searchPublicMethod(ext.getClass(),ObjectManager.METHOD_SUPERCLASS_METHOD,args2);
		ret = (String)mm.invoke(ext,args2);
		assertEquals("super_call:","SUPERCLASS",ret);

		//test extend object.call -> super.protected
		Object[] args1 = new Object[]{"protectedMethod",new Object[0]};
		mm = Utils.searchPublicMethod(ext.getClass(),ObjectManager.METHOD_SUPERCLASS_METHOD,args1);
		ret = (String)mm.invoke(ext,args1);
		assertEquals("protected_call:","PROTECTED",ret);
	}

	public void testImport() throws Exception {
		assertNotNull(manager.staticReference("System"));

		Object id = null;
		try {
			id = manager.createObject("Point",null);
		} catch (ClassNotFoundException e) {
		}
		assertNull(id);
		manager.addImport("java.awt.*");
		id = manager.createObject("Point",null);
		Object obj = manager.getObject(id);
		assertEquals(java.awt.Point.class,obj.getClass());
	}

	public void testImportOverride() throws Exception {
		Object id = null;
		try {
			id = manager.staticReference("List");
		} catch (ClassNotFoundException e) {
		}
		assertNull(id);
		manager.addImport("java.awt.*");
		id = manager.staticReference("List");
		Object obj = manager.getObject(id);
		assertTrue(java.awt.List.class.equals(obj));

		manager.addImport("java.util.List");
		id = null;
		try {
			id = manager.staticReference("List");//can not create instance
		} catch (RuntimeException e){
		}
		assertNull(id);
	}

	//=============================

	protected String protectedMethod() {
		return "PROTECTED";
	}

	public String sampleMethod() {
		return "SUPERCLASS";
	}
}