import jp.gr.java_conf.ccs2.core.MessageMonitor;


public class RMISession {

	private MessageMonitor monitor;

	private Object sid;
	private Object proxyId;
	private String method;
	private Object[] args;

	private Object returnObject;
	private Exception exception;

	private ISessionProcedure call_procedure = null;

	private Object call_returnObject = null;
	private Exception call_exception = null;

	private Object lock = new Object();
	private String TAB = "    ";

	RMISession(MessageMonitor mon,Object sid,Object proxyId,String method,Object[] args) {
		this.monitor = mon;
		this.sid = sid;
		this.proxyId = proxyId;
		this.method = method;
		this.args = args;
		TAB = "    |"+sid+"|";
	}

	Object rmiCall(IOverridedRMI _rmi) throws Exception {
		monitor.debug(TAB+"===== New Session");
		final IOverridedRMI rmi = _rmi;
		Thread thread = new Thread(new Runnable() {
				public void run() {
					monitor.debug(TAB+"TOP.Start:"+method+" : "+args.length+" args.");
					try {
						setResultValue(rmi.call(sid,proxyId,method,args));
					} catch (Exception e) {
						setException(e);
					} finally {
						monitor.debug(TAB+"TOP.Terminate");
					}
				}
			});
		thread.start();
		while (returnObject == null && exception == null) {
			synchronized (lock) {
				try {
					monitor.debug(TAB+"SESSION.Stop");
					lock.wait();
				} catch (InterruptedException e) {
					monitor.recordStackTrace(e);
					break;
				}
			}
			monitor.debug(TAB+"SESSION.Wakeup");
			if (call_procedure != null) {
				monitor.debug(TAB+"SESSION.ExecProc");
				try {
					call_returnObject = call_procedure.exec();
					if (call_returnObject == null) {
						call_returnObject = NULL;
					}
				} catch (Exception e) {
					call_exception = e;
				}
				synchronized (lock) {
					lock.notifyAll();
				}
			}
		}
		if (exception != null) {
			monitor.verbose(TAB+"SESSION.Exception:"+exception);
			throw exception;
		} else {
			monitor.debug(TAB+"SESSION.Finished:"+returnObject);
		}
		if (returnObject ==  NULL) {
			return null;
		}
		return returnObject;
	}

	private void setResultValue(Object obj) {
		monitor.debug(TAB+"TOP.Finished:"+returnObject);
		if (obj == null) {
			obj = NULL;
		}
		returnObject = obj;
		synchronized (lock) {
			lock.notifyAll();
		}
	}

	private void setException(Exception e) {
		monitor.debug(TAB+"TOP.Exception:"+e);
		exception = e;
		synchronized (lock) {
			lock.notifyAll();
		}
	}

	public Object sessionCall(ISessionProcedure p) throws Exception {
		monitor.debug(TAB+"RMI.Start:"+p.getTitle());
		call_procedure = p;
		synchronized (lock) {
			lock.notifyAll();
		}
		while(call_returnObject == null && call_exception == null) {
			synchronized (lock) {
				monitor.debug(TAB+"RMI.Stop");
				lock.wait();
			}
			monitor.debug(TAB+"RMI.Wakeup");
		}
		try {
			if (call_exception != null) {
				monitor.verbose(TAB+"RMI.Exception:"+call_exception);
				throw call_exception;
			} else {
				monitor.debug(TAB+"RMI.Finished:"+call_returnObject);
			}
			if (call_returnObject == NULL) {
				return null;
			}
			return call_returnObject;
		} finally {
			call_procedure = null;
			call_returnObject = null;
			call_exception = null;
		}
	}

	private static final Object NULL = new Object();
}