import java.util.HashMap;
import java.util.Vector;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class SessionManager {

	private IOverridedRMI overrideRMI;
	private MessageMonitor monitor;
	private ObjectManager objectManager;

	private HashMap sessionTable = new HashMap();
	private HashMap threadTable = new HashMap();

	private int sessionId = 0;
	private Object sessionIdLock = new Object();

	public SessionManager(MessageMonitor mon,IOverridedRMI or) {
		monitor = mon;
		overrideRMI = or;
	}

	public void init(ObjectManager om) {
		objectManager = om;
	}

	private Object createSessionId() {
		synchronized(sessionIdLock) {
			sessionId++;
			return "SID:"+sessionId;
		}
	}

	private Object getThreadId(Object sid) {
		Object tid = threadTable.get(Thread.currentThread());
		if (tid == null) {
			return sid;
		}
		return tid;
	}

	public Object rmiCall(Object proxyId,String method,Object[] args) throws Exception {
		args = objectManager.obj2ids(args);
		Object sid = createSessionId();
		Object tid = getThreadId(sid);
		Thread ct = Thread.currentThread();
		monitor.debug("SessionManager  SID:"+sid+"  TID:"+tid+" ["+ct.getName()+" in "+ct.getThreadGroup().getName() +"]");
		try {
			RMISession session = new RMISession(monitor,sid,proxyId,method,args);
			sessionTable.put(sid,session);
			threadTable.put(ct,tid);
			return session.rmiCall(overrideRMI);
		} finally {
			sessionTable.remove(sid);
		}
	}

	public Object sessionCall(Object sid,ISessionProcedure p) throws Exception {
		RMISession s = getSession(sid);
		return s.sessionCall(p);
	}

	private RMISession getSession(Object sid) {
		return (RMISession)sessionTable.get(sid);
	}

}