
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import jp.gr.java_conf.ccs2.core.MessageMonitor;
import org.apache.xmlrpc.XmlRpcServer;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcHandler;

/**
   connect XMLRPC <--> BridgeServer
*/
public class XMLRPC_JBServer {

	public static final String NULL_SYMBOL = "$$$NULL$$$";

	private MessageMonitor monitor;
	private BridgeServer bridgeServer;

	public XMLRPC_JBServer(int port,MessageMonitor mon,BridgeServer bs) throws IOException {
		this.monitor = mon;
		this.bridgeServer = bs;

		XmlRpcServer svr = new XmlRpcServer();
		monitor.normal("MaxClient:"+svr.getMaxThreads());
		svr.setMaxThreads(16);
		WebServer webserver = new WebServer(port,null,svr);
		//WebServer webserver = new WebServer(port) ;
		webserver.addHandler("jb",handler);
		webserver.start();
	}

	private static Object[] cdr(Vector v) {
		return cdr(v,1);
	}

	private static Object[] cdr(Vector v,int skip) {
		Object[] ret = new Object[v.size()-skip];
		for (int i=0;i<ret.length;i++) {
			ret[i] = v.elementAt(i+skip);
		}
		return ret;
	}

	private static String pid2str(Object pid) {
		return pid.toString();
	}

	private XmlRpcHandler handler = new XmlRpcHandler() {

			private String dumpParams(Vector params) {
				StringBuffer sb = new StringBuffer();
				for(int i=0;i<params.size();i++) {
					sb.append(params.elementAt(i)).append(" ");
				}
				return sb.toString();
			}

			public Object execute(String method,Vector params) throws Exception {
				if (method.startsWith("jb.")) {
					method = method.substring(3);
				}
				monitor.debug("> "+method+" : "+dumpParams(params));
				try {
					Object ret = null;
					if ("call".equals(method)) {
						Object proxyId = params.elementAt(0);
						String methodName = (String)params.elementAt(1);
						ret = bridgeServer.call(proxyId,methodName,cdr(params,2));
					} else if ("new".equals(method)) {
						String fqcn = (String)params.elementAt(0);
						ret = pid2str(bridgeServer.jnew(fqcn,cdr(params)));
					} else if ("superCall".equals(method)) {
						Object proxyId = params.elementAt(0);
						String methodName = (String)params.elementAt(1);
						ret = bridgeServer.superCall(proxyId,methodName,cdr(params,2));
					} else if ("classname".equals(method)) {
						ret = bridgeServer.inspectClassname(params.elementAt(0));
					} else if ("static".equals(method)) {
						String fqcn = (String)params.elementAt(0);
						ret = bridgeServer.getStaticClass(fqcn);
					} else if ("ref".equals(method)) {
						Object proxyId = params.elementAt(0);
						String fieldName = (String)params.elementAt(1);
						ret = bridgeServer.ref(proxyId,fieldName);
					} else if ("set".equals(method)) {
						Object proxyId = params.elementAt(0);
						String fieldName = (String)params.elementAt(1);
						Object val = params.elementAt(2);
						bridgeServer.set(proxyId,fieldName,val);
					} else if ("sessionCall".equals(method)) {
						Object sid = params.elementAt(0);
						final String nestedMethod = (String)params.elementAt(1);
						final Vector args = new Vector();
						args.addAll(Arrays.asList(cdr(params,2)));
						ISessionProcedure sp = new ISessionProcedure() {
								public String getTitle() { return nestedMethod; }
								public Object exec() throws Exception {
									return execute(nestedMethod,args);
								}
							};
						ret = bridgeServer.sessionCall(sid,sp);
					} else if ("extend".equals(method)) {
						String fqcn = (String)params.elementAt(0);
						ret = pid2str(bridgeServer.jextend(fqcn,cdr(params)));
					} else if ("classinfo".equals(method)) {
						String fqcn = (String)params.elementAt(0);
						ret = bridgeServer.getClassInfo(fqcn);
					} else if ("impl".equals(method)) {
						Object proxyId = params.elementAt(0);
						String name = (String)params.elementAt(1);
						Boolean flag = (Boolean)params.elementAt(2);
						bridgeServer.setImplementFlag(proxyId,name,flag);
					} else if ("import".equals(method)) {
						String lines = (String)params.elementAt(0);
						bridgeServer.jimport(lines);
					} else if ("unlink".equals(method)) {
						Object proxyId = params.elementAt(0);
						bridgeServer.unlink(proxyId);
					} else if ("exit".equals(method)) {
						bridgeServer.exit();
						ret = "EXIT";
					} else if ("dump".equals(method)) {
						bridgeServer.dumpObjects();
						ret = "DUMP";
					} else {
						throw new RuntimeException("Not supported method. "+method);
					}
					if (ret == null) {
						return NULL_SYMBOL;
					}
					return ret;
				} catch (Exception e) {
					monitor.recordStackTrace(e);
					throw e;
				}
			}

		};

}
