/*
 * Decompiled with CFR 0.152.
 */
package jbridge;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import jbridge.IObjectTransformer;
import jbridge.IOverrideCall;
import jbridge.ISessionProcedure;
import jbridge.ObjectManager;
import jbridge.SessionManager;
import jbridge.Utils;
import jp.gr.java_conf.ccs2.core.MessageMonitor;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class BridgeServer {
    private MessageMonitor monitor;
    private ObjectManager objectManager;
    private SessionManager sessionManager;
    private Runnable terminator = new Runnable(){

        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    };

    public BridgeServer(MessageMonitor mon, IOverrideCall rb, IObjectTransformer ot) {
        this.monitor = mon;
        this.sessionManager = new SessionManager(this.monitor, rb);
        this.objectManager = new ObjectManager(this.monitor, this.sessionManager, ot);
        this.sessionManager.init(this.objectManager);
    }

    public Object jnew(String fqcn, Object[] args) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            args = this.objectManager.id2objs(args);
            Utils.writeArguments(this.monitor, 1, "!! [  NEW ] " + fqcn, args);
            return this.objectManager.createObject(fqcn, args);
        }
        catch (InvocationTargetException e) {
            this.monitor.recordStackTrace(e);
            Throwable t = e.getCause();
            if (t != null && t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw e;
        }
    }

    public Object jextend(String fqcns, Object[] args) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            args = this.objectManager.id2objs(args);
            Utils.writeArguments(this.monitor, 1, "!! [EXTEND] " + fqcns, args);
            return this.objectManager.extendObject(fqcns, args);
        }
        catch (InvocationTargetException e) {
            this.monitor.recordStackTrace(e);
            Throwable t = e.getCause();
            if (t != null && t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw e;
        }
    }

    public String inspectClassname(Object proxyId) {
        return this.objectManager.inspectClassnameByKey(proxyId);
    }

    public Object ref(Object proxyId, String fieldName) throws IllegalAccessException {
        Object obj = this.objectManager.getObject(proxyId);
        if (obj == null) {
            throw new RuntimeException("Object not found, key=" + proxyId);
        }
        try {
            Object ret = null;
            String className = null;
            if (obj instanceof Class) {
                Field f = ((Class)obj).getField(fieldName);
                ret = f.get(null);
                className = ((Class)obj).getName();
            } else {
                Field f = obj.getClass().getField(fieldName);
                ret = f.get(obj);
                className = obj.getClass().getName();
            }
            Utils.writeArray(this.monitor, 1, new Object[]{"!! [  REF ] ", ret, " <= ", className, "#", fieldName});
            return this.returnFilter(ret);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("No such field: " + fieldName);
        }
    }

    public void set(Object proxyId, String fieldName, Object value) throws IllegalAccessException {
        value = this.objectManager.id2obj(value);
        Object obj = this.objectManager.getObject(proxyId);
        if (obj == null) {
            throw new RuntimeException("Object not found, key=" + proxyId);
        }
        try {
            Object ret = null;
            String className = null;
            if (obj instanceof Class) {
                Field f = ((Class)obj).getField(fieldName);
                f.set(null, value);
                className = ((Class)obj).getName();
            } else {
                Field f = obj.getClass().getField(fieldName);
                f.set(obj, value);
                className = obj.getClass().getName();
            }
            Utils.writeArray(this.monitor, 1, new Object[]{"!! [  SET ] ", className, "#", fieldName, " <= ", value});
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("No such field: " + fieldName);
        }
    }

    private Object generalCall(Object proxyId, String methodName, Object[] targs) throws IllegalAccessException, InvocationTargetException {
        Object obj = this.objectManager.getObject(proxyId);
        if (obj == null) {
            throw new RuntimeException("Object not found, key=" + proxyId);
        }
        try {
            Object ret = null;
            String className = null;
            if (obj instanceof Class) {
                try {
                    ret = this.objectManager.searchStaticMethod((Class)obj, methodName, targs).invoke(null, targs);
                    className = ((Class)obj).getName();
                }
                catch (NoSuchMethodException e) {
                    try {
                        ret = this.objectManager.searchPublicMethod(obj.getClass(), methodName, targs).invoke(obj, targs);
                        className = obj.getClass().getName();
                    }
                    catch (NoSuchMethodException ex) {
                        throw e;
                    }
                }
            } else {
                ret = this.objectManager.searchPublicMethod(obj.getClass(), methodName, targs).invoke(obj, targs);
                className = obj.getClass().getName();
            }
            Utils.writeArguments(this.monitor, 1, new Object[]{"!! [ CALL ] ", ret, " <= ", className, "#", methodName}, targs);
            return this.returnFilter(ret);
        }
        catch (NoSuchMethodException e) {
            this.monitor.recordStackTrace(e);
            if (obj instanceof Class) {
                throw new RuntimeException("No such method: " + methodName + " in " + ((Class)obj).getName() + ", " + obj.getClass().getName());
            }
            throw new RuntimeException("No such method: " + methodName + " in " + obj.getClass().getName());
        }
        catch (Throwable e) {
            Utils.writeArguments(this.monitor, 1, new Object[]{"!! [=EXCEPTION=]  ", e.getClass().getName(), " | ", e.getMessage(), " <= ", obj.getClass().getName(), "#", methodName}, targs);
            Throwable t = e;
            while ((t = e.getCause()) != null) {
                this.monitor.debug("  -> " + t.getClass().getName());
                e = t;
            }
            if (e != null && e instanceof RuntimeException) {
                this.monitor.verbose("    => " + e.getClass().getName());
                throw (RuntimeException)e;
            }
            this.monitor.recordStackTrace(e);
            throw new RuntimeException(e);
        }
    }

    private Object returnFilter(Object ret) {
        if (ret == null) {
            return null;
        }
        return this.objectManager.obj2id(ret);
    }

    public Object call(Object proxyId, String methodName, Object[] args) throws IllegalAccessException, InvocationTargetException {
        return this.generalCall(proxyId, methodName, this.objectManager.id2objs(args));
    }

    public Object superCall(Object proxyId, String methodName, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Object[] rargs = new Object[]{methodName, this.objectManager.id2objs(args)};
        return this.generalCall(proxyId, "__callSuperclassMethod", rargs);
    }

    public Object sessionCall(Object sid, ISessionProcedure _sp) throws IllegalAccessException, InvocationTargetException {
        ISessionProcedure sp = _sp;
        try {
            return this.sessionManager.sessionCall(sid, sp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setImplementFlag(Object proxyId, String methodName, Boolean flag) throws NoSuchMethodException, IllegalAccessException {
        Object obj = this.objectManager.getObject(proxyId);
        if (obj == null) {
            throw new RuntimeException("Object not found, key=" + proxyId);
        }
        try {
            Field f = obj.getClass().getField(ObjectManager.FIELD_IMPL_FLAG_PREFIX + methodName);
            f.set(obj, flag);
            Utils.writeArray(this.monitor, 1, new Object[]{"!! [ IMPL ] ", proxyId.toString(), methodName, " <= ", flag.toString()});
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("BUG: can not set an impl-flag: " + methodName, e);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
    }

    public void jimport(String lines) {
        this.objectManager.addImport(lines);
        this.monitor.verbose("!! [IMPORT]  " + lines);
    }

    public void unlink(Object key) {
        Object obj = this.objectManager.getObject(key);
        if (obj != null) {
            this.objectManager.removeObject(key);
            this.monitor.verbose("!! [UNLINK]  " + key + "  (" + obj.toString() + ")");
        } else {
            this.monitor.verbose("!! [UNLINK]  " + key + "  (miss! object not found.)");
        }
    }

    public boolean isProxyId(Object obj) {
        return this.objectManager.isKey(obj);
    }

    public Object getObject(Object key) {
        return this.objectManager.getObject(key);
    }

    public void exit() {
        this.monitor.normal("!! [ EXIT ]");
        new Thread(this.terminator).start();
    }

    public String getClassInfo(String classname) throws ClassNotFoundException {
        Class cls = this.objectManager.findClass(classname);
        return StringUtil.conbine(Utils.getClassInfo(cls), ",");
    }

    public Object getStaticClass(String classname) throws ClassNotFoundException {
        return this.objectManager.staticReference(classname);
    }

    public void dumpObjects() {
        StringBuffer sb = new StringBuffer("---(Object Dump)------------\n");
        Object[] ret = this.getAllObjectKeys();
        for (int i = 0; i < ret.length; ++i) {
            sb.append("[").append(ret[i].toString()).append("] ");
            Object obj = this.objectManager.getObject(ret[i]);
            if (obj == null) {
                sb.append("null");
            } else {
                sb.append(obj.getClass().getName()).append(" | ");
                sb.append(obj.toString());
            }
            sb.append("\n");
        }
        sb.append("--------------------------------");
        this.monitor.normal(sb.toString());
    }

    public Object[] getAllObjectKeys() {
        return this.objectManager.getAllObjectKeys();
    }
}

