/*
 * Decompiled with CFR 0.152.
 */
package jbridge;

import java.util.ArrayList;
import java.util.HashMap;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class ClassFinder {
    private HashMap cacheTable = new HashMap();
    private ArrayList importList = new ArrayList();
    private MessageMonitor monitor;

    public ClassFinder(MessageMonitor m) {
        this.monitor = m;
        this.importList.add("java.lang.");
    }

    public void addImport(String line) {
        String[] lines = line.split(",");
        for (int i = 0; i < lines.length; ++i) {
            String ai = lines[i];
            if (this.importList.contains(ai)) continue;
            if (ai.endsWith("*")) {
                ai = ai.substring(0, ai.length() - 1);
            }
            this.importList.add(0, ai);
            this.monitor.debug("ClassFinder: import : " + ai);
        }
        this.cacheTable.clear();
    }

    public Class findClass(String cn) throws ClassNotFoundException {
        Class ret = this.getClass(cn);
        if (ret != null) {
            return ret;
        }
        ret = (Class)this.cacheTable.get(cn);
        if (ret != null) {
            return ret;
        }
        for (int i = 0; i < this.importList.size(); ++i) {
            String prefix = (String)this.importList.get(i);
            if (prefix.endsWith(".")) {
                String fqcn = prefix + cn;
                this.monitor.debug("ClassFinder: try : " + fqcn);
                ret = this.getClass(fqcn);
            } else {
                if (!prefix.endsWith(cn)) continue;
                ret = this.getClass(prefix);
            }
            if (ret == null) continue;
            this.cacheTable.put(cn, ret);
            return ret;
        }
        throw new ClassNotFoundException("Not found class: " + cn);
    }

    public String fqcn(String cn) throws ClassNotFoundException {
        return this.findClass(cn).getName();
    }

    private Class getClass(String fqcn) {
        try {
            return Class.forName(fqcn);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

