/*
 * Decompiled with CFR 0.152.
 */
package jbridge;

import java.util.HashMap;
import jbridge.ConsCell;

public class ObjectRegistry {
    private int currentKeyId = 0;
    private HashMap objectTable = new HashMap();
    private HashMap reverseTable = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object registerObject(Object obj) {
        HashMap hashMap = this.reverseTable;
        synchronized (hashMap) {
            ConsCell header = (ConsCell)this.reverseTable.get(obj);
            if (header != null) {
                ConsCell cons = header.searchCellByObject(obj);
                if (cons != null) {
                    return cons.key();
                }
            } else {
                header = new ConsCell();
                this.reverseTable.put(obj, header);
            }
            String key = "%%%JBOM:" + this.currentKeyId++ + ":" + obj.getClass().getName() + "%%%";
            header.append(new ConsCell(key, obj));
            this.objectTable.put(key, obj);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Object key) {
        HashMap hashMap = this.reverseTable;
        synchronized (hashMap) {
            Object obj = this.objectTable.remove(key);
            if (obj == null) {
                return;
            }
            ConsCell header = (ConsCell)this.reverseTable.get(obj);
            if (header != null) {
                header.removeByObject(obj);
                if (header.size() == 1) {
                    this.reverseTable.remove(obj);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKey(Object key) {
        HashMap hashMap = this.reverseTable;
        synchronized (hashMap) {
            return this.objectTable.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Object key) {
        HashMap hashMap = this.reverseTable;
        synchronized (hashMap) {
            return this.objectTable.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllObjectKeys() {
        HashMap hashMap = this.reverseTable;
        synchronized (hashMap) {
            return this.objectTable.keySet().toArray();
        }
    }

    public static void main(String[] args) {
        Integer o1 = new Integer(1);
        Integer o2 = new Integer(2);
        Integer o3 = new Integer(3);
        String k1 = "k1";
        String k2 = "k2";
        String k3 = "k3";
        ConsCell header = new ConsCell();
        header.append(new ConsCell(k1, o1));
        System.out.println(header + " : " + header.size());
        header.append(new ConsCell(k2, o2));
        System.out.println(header + " : " + header.size());
        header.append(new ConsCell(k3, o3));
        System.out.println(header + " : " + header.size());
        System.out.println("search k2: " + header.searchCellByObject(o2).car());
        header.removeByObject(o2);
        System.out.println(header + " : " + header.size());
        header.append(new ConsCell(k2, o2));
        System.out.println(header + " : " + header.size());
        header.removeByObject(o2);
        System.out.println(header + " : " + header.size());
        header.removeByObject(o1);
        System.out.println(header + " : " + header.size());
        header.removeByObject(o3);
        System.out.println(header + " : " + header.size());
    }
}

