/*
 * Decompiled with CFR 0.152.
 */
package jbridge;

import java.util.HashMap;
import jbridge.CallSession;
import jbridge.IOverrideCall;
import jbridge.ISessionProcedure;
import jbridge.ObjectManager;
import jbridge.Utils;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class SessionManager {
    private IOverrideCall overrideCall;
    private MessageMonitor monitor;
    private ObjectManager objectManager;
    private HashMap sessionTable = new HashMap();
    private HashMap threadTable = new HashMap();
    private int sessionId = 0;
    private Object sessionIdLock = new Object();

    public SessionManager(MessageMonitor mon, IOverrideCall or) {
        this.monitor = mon;
        this.overrideCall = or;
    }

    public void init(ObjectManager om) {
        this.objectManager = om;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createSessionId() {
        Object object = this.sessionIdLock;
        synchronized (object) {
            ++this.sessionId;
            return "SID:" + this.sessionId;
        }
    }

    private Object getThreadId(Object sid) {
        Object tid = this.threadTable.get(Thread.currentThread());
        if (tid == null) {
            return sid;
        }
        return tid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object overrideCall(Object proxyId, String method, Object[] args, Class returnTyep) throws Exception {
        args = this.objectManager.obj2ids(args);
        Object sid = this.createSessionId();
        Object tid = this.getThreadId(sid);
        Thread ct = Thread.currentThread();
        Utils.writeArray(this.monitor, 0, new Object[]{"SessionManager  SID:", sid.toString(), "  TID:", tid.toString(), " [", ct.getName(), " in ", ct.getThreadGroup().getName(), "]"});
        try {
            CallSession session = new CallSession(this.monitor, sid, proxyId, method, args, returnTyep);
            this.sessionTable.put(sid, session);
            this.threadTable.put(ct, tid);
            Object object = this.objectManager.id2obj(session.overrideCall(this.overrideCall));
            return object;
        }
        finally {
            this.sessionTable.remove(sid);
        }
    }

    public Object sessionCall(Object sid, ISessionProcedure p) throws Exception {
        CallSession s = this.getSession(sid);
        return s.sessionCall(p);
    }

    private CallSession getSession(Object sid) {
        return (CallSession)this.sessionTable.get(sid);
    }
}

