/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.binstream;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import jbridge.BridgeServer;
import jbridge.IBridgeBuilder;
import jbridge.IObjectTransformer;
import jbridge.IOverrideCall;
import jbridge.ISessionProcedure;
import jbridge.comm.binstream.BStream_OverrideCall;
import jbridge.comm.binstream.BinServer;
import jbridge.comm.binstream.ICommunicator;
import jbridge.comm.binstream.IMessageHandler;
import jp.gr.java_conf.ccs2.core.AppConfig;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class BStream_JBServer
implements IBridgeBuilder {
    private MessageMonitor monitor;
    private BridgeServer bridgeServer;
    private ICommunicator bserver;
    private IOverrideCall overrideCaller;
    private HashMap handlerMap;
    private IObjectTransformer transformer = new IObjectTransformer(){

        public Object exportFilter(Object arg) {
            if (arg == null) {
                return null;
            }
            if (arg.getClass().isPrimitive() || arg instanceof String || arg instanceof Integer || arg instanceof Double || arg instanceof Byte || arg instanceof Float || arg instanceof Long || arg instanceof Short || arg instanceof Boolean) {
                return arg;
            }
            return null;
        }

        public Object importFilter(Object obj) {
            return obj;
        }
    };
    private IMessageHandler h_call = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbersPlus(2, args);
            Object proxyId = args[0];
            String methodName = (String)args[1];
            return BStream_JBServer.this.bridgeServer.call(proxyId, methodName, BStream_JBServer.cdr(args, 2));
        }
    };
    private IMessageHandler h_new = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbersPlus(1, args);
            String fqcn = (String)args[0];
            return BStream_JBServer.this.bridgeServer.jnew(fqcn, BStream_JBServer.cdr(args));
        }
    };
    private IMessageHandler h_superCall = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbersPlus(2, args);
            Object proxyId = args[0];
            String methodName = (String)args[1];
            return BStream_JBServer.this.bridgeServer.superCall(proxyId, methodName, BStream_JBServer.cdr(args, 2));
        }
    };
    private IMessageHandler h_classname = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbers(1, args);
            return BStream_JBServer.this.bridgeServer.inspectClassname(args[0]);
        }
    };
    private IMessageHandler h_static = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbers(1, args);
            String fqcn = (String)args[0];
            return BStream_JBServer.this.bridgeServer.getStaticClass(fqcn);
        }
    };
    private IMessageHandler h_ref = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbers(2, args);
            Object proxyId = args[0];
            String fieldName = (String)args[1];
            return BStream_JBServer.this.bridgeServer.ref(proxyId, fieldName);
        }
    };
    private IMessageHandler h_set = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbers(3, args);
            Object proxyId = args[0];
            String fieldName = (String)args[1];
            Object val = args[2];
            BStream_JBServer.this.bridgeServer.set(proxyId, fieldName, val);
            return null;
        }
    };
    private IMessageHandler h_sessionCall = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbersPlus(2, args);
            Object sid = args[0];
            String nestedMethod = (String)args[1];
            Object[] targs = BStream_JBServer.cdr(args, 2);
            ISessionProcedure sp = new ISessionProcedure(this, nestedMethod, targs){
                private final /* synthetic */ String val$nestedMethod;
                private final /* synthetic */ Object[] val$targs;
                private final /* synthetic */ 9 this$1;
                {
                    this.this$1 = this$1;
                    this.val$nestedMethod = val$nestedMethod;
                    this.val$targs = val$targs;
                }

                public String getTitle() {
                    return this.val$nestedMethod;
                }

                public Object exec() throws Exception {
                    return BStream_JBServer.access$600(9.access$500(this.this$1), this.val$nestedMethod, this.val$targs);
                }
            };
            return BStream_JBServer.this.bridgeServer.sessionCall(sid, sp);
        }

        static /* synthetic */ BStream_JBServer access$500(9 x0) {
            return x0.BStream_JBServer.this;
        }
    };
    private IMessageHandler h_extend = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbersPlus(1, args);
            String fqcn = (String)args[0];
            return BStream_JBServer.this.bridgeServer.jextend(fqcn, BStream_JBServer.cdr(args));
        }
    };
    private IMessageHandler h_classinfo = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbers(1, args);
            String fqcn = (String)args[0];
            return BStream_JBServer.this.bridgeServer.getClassInfo(fqcn);
        }
    };
    private IMessageHandler h_impl = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbers(3, args);
            Object proxyId = args[0];
            String name = (String)args[1];
            Boolean flag = (Boolean)args[2];
            BStream_JBServer.this.bridgeServer.setImplementFlag(proxyId, name, flag);
            return null;
        }
    };
    private IMessageHandler h_import = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbers(1, args);
            String lines = (String)args[0];
            BStream_JBServer.this.bridgeServer.jimport(lines);
            return null;
        }
    };
    private IMessageHandler h_unlink = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbers(1, args);
            Object proxyId = args[0];
            BStream_JBServer.this.bridgeServer.unlink(proxyId);
            return null;
        }
    };
    private IMessageHandler h_exit = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.bridgeServer.exit();
            return "EXIT";
        }
    };
    private IMessageHandler h_allObjects = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            return BStream_JBServer.this.bridgeServer.getAllObjectKeys();
        }
    };
    private IMessageHandler h_dump = new IMessageHandler(){

        public Object send(Object[] args) throws Exception {
            BStream_JBServer.this.checkArgNumbers(0, args);
            BStream_JBServer.this.bridgeServer.dumpObjects();
            return "DUMP";
        }
    };

    public void setConfig(MessageMonitor mon, AppConfig config) throws IOException {
        this.monitor = mon;
        int port = config.getOptionInteger("remoteport", -1);
        if (port == -1) {
            throw new RuntimeException("Port number is not specified.");
        }
        this.bserver = new BinServer(this.monitor, port);
        this.overrideCaller = new BStream_OverrideCall(this.bserver);
        this.registHandlers();
    }

    public IObjectTransformer getObjectTransformer() {
        return this.transformer;
    }

    public IOverrideCall getOverrideCaller() {
        return this.overrideCaller;
    }

    public void start(BridgeServer bs) {
        this.bridgeServer = bs;
        this.bserver.start();
    }

    private static void printHelp() {
        System.out.println("=== BinStream BridgeBuilder ");
        System.out.println("     -remotehost:localhost (client hostname)\n");
        System.out.println("     -remoteport:9009 (client service port)\n");
    }

    private void registHandlers() {
        this.handlerMap = new HashMap();
        this.handlerMap.put("call", this.h_call);
        this.handlerMap.put("new", this.h_new);
        this.handlerMap.put("superCall", this.h_superCall);
        this.handlerMap.put("classname", this.h_classname);
        this.handlerMap.put("static", this.h_static);
        this.handlerMap.put("ref", this.h_ref);
        this.handlerMap.put("set", this.h_set);
        this.handlerMap.put("sessionCall", this.h_sessionCall);
        this.handlerMap.put("extend", this.h_extend);
        this.handlerMap.put("classinfo", this.h_classinfo);
        this.handlerMap.put("impl", this.h_impl);
        this.handlerMap.put("import", this.h_import);
        this.handlerMap.put("unlink", this.h_unlink);
        this.handlerMap.put("exit", this.h_exit);
        this.handlerMap.put("allObjects", this.h_allObjects);
        this.handlerMap.put("dump", this.h_dump);
        Iterator it = this.handlerMap.keySet().iterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            IMessageHandler h = (IMessageHandler)this.handlerMap.get(k);
            this.bserver.addHandler(k, h);
        }
    }

    private Object dispach(String method, Object[] args) throws Exception {
        IMessageHandler h = (IMessageHandler)this.handlerMap.get(method);
        if (h != null) {
            return h.send(args);
        }
        throw new IOException("No such remote method: " + method);
    }

    private void checkArgNumbers(int num, Object[] args) throws IOException {
        if (num == 0 && args == null) {
            return;
        }
        if (args.length == num) {
            return;
        }
        throw new IOException("Wrong argument number: expected=" + num + "  but received=" + args.length);
    }

    private void checkArgNumbersPlus(int num, Object[] args) throws IOException {
        if (num == 0 && args == null) {
            return;
        }
        if (args.length >= num) {
            return;
        }
        throw new IOException("Wrong argument number: expected=" + num + "  but received=" + args.length);
    }

    private static Object[] cdr(Object[] v) {
        return BStream_JBServer.cdr(v, 1);
    }

    private static Object[] cdr(Object[] v, int skip) {
        Object[] ret = new Object[v.length - skip];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = v[i + skip];
        }
        return ret;
    }

    static /* synthetic */ Object access$600(BStream_JBServer x0, String x1, Object[] x2) throws Exception {
        return x0.dispach(x1, x2);
    }
}

