/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.binstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jbridge.comm.binstream.AbstractTransferObject;
import jbridge.comm.binstream.BinConstants;
import jbridge.comm.binstream.BinDecoder;
import jbridge.comm.binstream.BinEncoder;
import jbridge.comm.binstream.DecodeHandlerClass2;

public class CallingObject
extends AbstractTransferObject
implements BinConstants {
    public final String name;
    public final Object[] args;

    public String toString() {
        return "CallingObject: sid=" + this.sid + " name=" + this.name + " args:" + this.args.length;
    }

    public CallingObject(Object s, String n, Object[] a) {
        super(s);
        this.name = n;
        if (a == null) {
            a = new Object[]{};
        }
        this.args = a;
    }

    static CallingObject getCallingObject(InputStream in) throws IOException {
        DecodeHandlerClass2 ret = new DecodeHandlerClass2();
        BinDecoder.read(in, ret);
        Object sid = ret.value;
        BinDecoder.read(in, ret);
        String name = (String)ret.value;
        BinDecoder.read(in, ret);
        Object[] args = ret.list;
        return new CallingObject(sid, name, args);
    }

    protected byte getMessageType() {
        return 0;
    }

    protected void exec_impl(OutputStream out) throws IOException {
        BinEncoder.writeObject(out, this.sid);
        BinEncoder.write(out, this.name);
        BinEncoder.writeList(out, this.args);
        out.flush();
    }
}

