/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.xmlrpc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Vector;
import jbridge.BridgeServer;
import jbridge.IBridgeBuilder;
import jbridge.IObjectTransformer;
import jbridge.IOverrideCall;
import jbridge.ISessionProcedure;
import jbridge.Utils;
import jbridge.comm.xmlrpc.XMLRPC_OverrideCall;
import jp.gr.java_conf.ccs2.core.AppConfig;
import jp.gr.java_conf.ccs2.core.MessageMonitor;
import jp.gr.java_conf.ccs2.util.StringUtil;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcHandler;

public class XMLRPC_JBServer
implements IBridgeBuilder {
    public static final String NULL_SYMBOL = "$$$NULL$$$";
    public static final String LONG_SYMBOL = "$$$LONG$$$";
    public static final String TYPED_ARRAY_SYMBOL = "$$$TYPED_A$$$";
    public static final String EXCEPTION_SYMBOL = "$$$EXCEPTION$$$";
    public static final String EXCEPTION_SEP = "__$$$__";
    private static final String TA_INT1 = "t_int1";
    private static final String TA_INT2 = "t_int2";
    private static final String TA_INT4 = "t_int4";
    private static final String TA_INT8 = "t_int8";
    private static final String TA_FLOAT = "t_float";
    private static final String TA_DOUBLE = "t_double";
    private static final String TA_DECIMAL = "t_decimal";
    private static final String TA_STRING = "t_string";
    private static final String TA_BOOLEAN = "t_boolean";
    private MessageMonitor monitor;
    private BridgeServer bridgeServer;
    private WebServer webserver;
    private IOverrideCall overrideCaller;
    private XmlRpcHandler handler = new XmlRpcHandler(){

        private String dumpParams(Vector params) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < params.size(); ++i) {
                sb.append(params.elementAt(i)).append(" ");
            }
            return sb.toString();
        }

        public Object execute(String method, Vector params) throws Exception {
            if (method.startsWith("jb.")) {
                method = method.substring(3);
            }
            Utils.writeArguments(XMLRPC_JBServer.this.monitor, 0, "> " + method, params);
            try {
                Object ret = null;
                if ("call".equals(method)) {
                    Object proxyId = params.elementAt(0);
                    String methodName = (String)params.elementAt(1);
                    ret = XMLRPC_JBServer.this.bridgeServer.call(proxyId, methodName, XMLRPC_JBServer.cdr(params, 2));
                } else if ("new".equals(method)) {
                    String fqcn = (String)params.elementAt(0);
                    ret = XMLRPC_JBServer.pid2str(XMLRPC_JBServer.this.bridgeServer.jnew(fqcn, XMLRPC_JBServer.cdr(params)));
                } else if ("superCall".equals(method)) {
                    Object proxyId = params.elementAt(0);
                    String methodName = (String)params.elementAt(1);
                    ret = XMLRPC_JBServer.this.bridgeServer.superCall(proxyId, methodName, XMLRPC_JBServer.cdr(params, 2));
                } else if ("classname".equals(method)) {
                    ret = XMLRPC_JBServer.this.bridgeServer.inspectClassname(params.elementAt(0));
                } else if ("static".equals(method)) {
                    String fqcn = (String)params.elementAt(0);
                    ret = XMLRPC_JBServer.this.bridgeServer.getStaticClass(fqcn);
                } else if ("ref".equals(method)) {
                    Object proxyId = params.elementAt(0);
                    String fieldName = (String)params.elementAt(1);
                    ret = XMLRPC_JBServer.this.bridgeServer.ref(proxyId, fieldName);
                } else if ("set".equals(method)) {
                    Object proxyId = params.elementAt(0);
                    String fieldName = (String)params.elementAt(1);
                    Object val = params.elementAt(2);
                    XMLRPC_JBServer.this.bridgeServer.set(proxyId, fieldName, val);
                } else if ("sessionCall".equals(method)) {
                    Object sid = params.elementAt(0);
                    String nestedMethod = (String)params.elementAt(1);
                    Vector<Object> args = new Vector<Object>();
                    args.addAll(Arrays.asList(XMLRPC_JBServer.cdr(params, 2)));
                    ISessionProcedure sp = new ISessionProcedure(this, nestedMethod, args){
                        private final /* synthetic */ String val$nestedMethod;
                        private final /* synthetic */ Vector val$args;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$nestedMethod = val$nestedMethod;
                            this.val$args = val$args;
                        }

                        public String getTitle() {
                            return this.val$nestedMethod;
                        }

                        public Object exec() throws Exception {
                            return this.this$1.execute(this.val$nestedMethod, this.val$args);
                        }
                    };
                    ret = XMLRPC_JBServer.this.bridgeServer.sessionCall(sid, sp);
                } else if ("extend".equals(method)) {
                    String fqcn = (String)params.elementAt(0);
                    ret = XMLRPC_JBServer.pid2str(XMLRPC_JBServer.this.bridgeServer.jextend(fqcn, XMLRPC_JBServer.cdr(params)));
                } else if ("classinfo".equals(method)) {
                    String fqcn = (String)params.elementAt(0);
                    ret = XMLRPC_JBServer.this.bridgeServer.getClassInfo(fqcn);
                } else if ("impl".equals(method)) {
                    Object proxyId = params.elementAt(0);
                    String name = (String)params.elementAt(1);
                    Boolean flag = (Boolean)params.elementAt(2);
                    XMLRPC_JBServer.this.bridgeServer.setImplementFlag(proxyId, name, flag);
                } else if ("import".equals(method)) {
                    String lines = (String)params.elementAt(0);
                    XMLRPC_JBServer.this.bridgeServer.jimport(lines);
                } else if ("unlink".equals(method)) {
                    Object proxyId = params.elementAt(0);
                    XMLRPC_JBServer.this.bridgeServer.unlink(proxyId);
                } else if ("exit".equals(method)) {
                    XMLRPC_JBServer.this.bridgeServer.exit();
                    ret = "EXIT";
                } else if ("allObjects".equals(method)) {
                    ret = XMLRPC_JBServer.this.bridgeServer.getAllObjectKeys();
                } else if ("dump".equals(method)) {
                    XMLRPC_JBServer.this.bridgeServer.dumpObjects();
                    ret = "DUMP";
                } else {
                    throw new RuntimeException("Not supported method. " + method);
                }
                if (ret == null) {
                    return XMLRPC_JBServer.NULL_SYMBOL;
                }
                return ret;
            }
            catch (Exception e) {
                Throwable t = e.getCause();
                if (t == null) {
                    t = e;
                }
                XMLRPC_JBServer.this.monitor.debug("Exporting exception : " + t.getClass().getName());
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                sw.flush();
                String[] res = new String[]{XMLRPC_JBServer.EXCEPTION_SYMBOL, t.getClass().getName(), t.getMessage(), sw.toString()};
                return StringUtil.conbine(res, XMLRPC_JBServer.EXCEPTION_SEP);
            }
        }
    };
    private IObjectTransformer transformer = new IObjectTransformer(){

        public Object exportFilter(Object arg) {
            if (arg == null) {
                return XMLRPC_JBServer.NULL_SYMBOL;
            }
            Class<?> c = arg.getClass();
            XMLRPC_JBServer.this.monitor.debug("ExportFilter:" + c.getName());
            if (c == Integer.TYPE || c == Double.TYPE || c == Boolean.TYPE || arg instanceof String || arg instanceof Integer || arg instanceof Double || arg instanceof Boolean) {
                return arg;
            }
            if (c.isArray()) {
                String at = c.getName();
                switch (at.charAt(1)) {
                    case 'B': 
                    case 'D': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        return this.to_int(arg);
                    }
                    case 'F': {
                        return this.to_double(arg);
                    }
                    case 'J': {
                        return this.to_long(arg);
                    }
                    case 'L': {
                        if (at.indexOf("java.lang.String") > 0) {
                            return arg;
                        }
                        if (at.indexOf("java.lang.Integer") > 0) {
                            return arg;
                        }
                        if (at.indexOf("java.lang.Byte") > 0 || at.indexOf("java.lang.Short") > 0) {
                            return this.to_int(arg);
                        }
                        if (at.indexOf("java.lang.Float") > 0) {
                            return this.to_double(arg);
                        }
                        if (at.indexOf("java.lang.Long") <= 0) break;
                        return this.to_long(arg);
                    }
                }
                return null;
            }
            if (arg instanceof Short || c == Short.TYPE) {
                return new Integer(((Short)arg).intValue());
            }
            if (arg instanceof Byte || c == Byte.TYPE) {
                return new Integer(((Byte)arg).intValue());
            }
            if (arg instanceof Float || c == Float.TYPE) {
                return new Double(((Float)arg).doubleValue());
            }
            if (arg instanceof Long || c == Long.TYPE) {
                return XMLRPC_JBServer.LONG_SYMBOL + arg.toString();
            }
            return null;
        }

        private Object to_int(Object arg) {
            int sz = Array.getLength(arg);
            Integer[] ret = new Integer[sz];
            for (int i = 0; i < sz; ++i) {
                ret[i] = new Integer(((Number)Array.get(arg, i)).intValue());
            }
            return ret;
        }

        private Object to_double(Object arg) {
            int sz = Array.getLength(arg);
            Double[] ret = new Double[sz];
            for (int i = 0; i < sz; ++i) {
                ret[i] = new Double(((Number)Array.get(arg, i)).doubleValue());
            }
            return ret;
        }

        private Object to_long(Object arg) {
            int sz = Array.getLength(arg);
            String[] ret = new String[sz];
            for (int i = 0; i < sz; ++i) {
                ret[i] = XMLRPC_JBServer.LONG_SYMBOL + Array.get(arg, i).toString();
            }
            return ret;
        }

        public Object importFilter(Object obj) {
            if (obj instanceof String) {
                String a = (String)obj;
                if (obj.equals(XMLRPC_JBServer.NULL_SYMBOL)) {
                    return null;
                }
                if (a.startsWith(XMLRPC_JBServer.LONG_SYMBOL)) {
                    return new Long(a.substring(XMLRPC_JBServer.LONG_SYMBOL.length()));
                }
                return a;
            }
            if (obj instanceof Vector && (obj = this.vector2array((Vector)obj)) instanceof String[]) {
                String[] array = (String[])obj;
                if (array.length == 0 || array[0] == null || array[0].indexOf(XMLRPC_JBServer.TYPED_ARRAY_SYMBOL) == -1) {
                    return obj;
                }
                return this.transTypedArray(array);
            }
            return obj;
        }

        private Object[] vector2array(Vector v) {
            if (v.size() == 0) {
                return new Object[0];
            }
            Object f = v.get(0);
            Class<?> c = f.getClass();
            if (c.equals(class$java$lang$String == null ? (class$java$lang$String = XMLRPC_JBServer.class$("java.lang.String")) : class$java$lang$String) && ((String)f).indexOf(XMLRPC_JBServer.TYPED_ARRAY_SYMBOL) == 0) {
                return v.toArray(new String[v.size()]);
            }
            for (int i = 1; i < v.size(); ++i) {
                Class<?> s = v.get(i).getClass();
                if (s == c) continue;
                Utils.writeArray(XMLRPC_JBServer.this.monitor, 0, new Object[]{" Transformed array: ", c.getName(), ", ", s.getName(), " ..."});
                return v.toArray();
            }
            XMLRPC_JBServer.this.monitor.debug(" Transformed array: " + c.getName());
            return v.toArray((Object[])Array.newInstance(c, v.size()));
        }

        private Object transTypedArray(String[] array) {
            String type = array[0].substring(XMLRPC_JBServer.TYPED_ARRAY_SYMBOL.length());
            XMLRPC_JBServer.this.monitor.debug(" Transformed typed array: " + type);
            if (type.equals(XMLRPC_JBServer.TA_INT1)) {
                byte[] ret = new byte[array.length - 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = Byte.parseByte(array[i + 1]);
                }
                return ret;
            }
            if (type.equals(XMLRPC_JBServer.TA_INT2)) {
                short[] ret = new short[array.length - 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = Short.parseShort(array[i + 1]);
                }
                return ret;
            }
            if (type.equals(XMLRPC_JBServer.TA_INT4)) {
                int[] ret = new int[array.length - 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = Integer.parseInt(array[i + 1]);
                }
                return ret;
            }
            if (type.equals(XMLRPC_JBServer.TA_INT8)) {
                long[] ret = new long[array.length - 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = Long.parseLong(array[i + 1]);
                }
                return ret;
            }
            if (type.equals(XMLRPC_JBServer.TA_FLOAT)) {
                float[] ret = new float[array.length - 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = Float.parseFloat(array[i + 1]);
                }
                return ret;
            }
            if (type.equals(XMLRPC_JBServer.TA_DOUBLE)) {
                double[] ret = new double[array.length - 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = Double.parseDouble(array[i + 1]);
                }
                return ret;
            }
            if (type.equals(XMLRPC_JBServer.TA_DECIMAL)) {
                BigDecimal[] ret = new BigDecimal[array.length - 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = new BigDecimal(array[i + 1]);
                }
                return ret;
            }
            if (type.equals(XMLRPC_JBServer.TA_STRING)) {
                String[] ret = new String[array.length - 1];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = array[i + 1];
                }
                return ret;
            }
            if (type.equals(XMLRPC_JBServer.TA_BOOLEAN)) {
                boolean[] ret = new boolean[array.length - 1];
                for (int i = 0; i < ret.length; ++i) {
                    String a = array[i + 1];
                    ret[i] = a != null || a.equalsIgnoreCase("true");
                }
                return ret;
            }
            throw new RuntimeException("Wrong array type symbol:" + type);
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    public XMLRPC_JBServer() {
        XmlRpc.setEncoding("UTF-8");
        try {
            XmlRpc.setDriver("xerces");
        }
        catch (Exception e) {
            this.monitor.recordStackTrace(e);
        }
    }

    public void setConfig(MessageMonitor mon, AppConfig config) throws IOException {
        this.monitor = mon;
        int port = config.getOptionInteger("javaport", 9010);
        this.webserver = new WebServer(port);
        this.webserver.addHandler("jb", this.handler);
        String rhost = config.getOptionString("remotehost", "localhost");
        int rport = config.getOptionInteger("remoteport", 9009);
        this.overrideCaller = new XMLRPC_OverrideCall(rhost, rport);
    }

    public IObjectTransformer getObjectTransformer() {
        return this.transformer;
    }

    public IOverrideCall getOverrideCaller() {
        return this.overrideCaller;
    }

    public void start(BridgeServer bs) {
        this.bridgeServer = bs;
        this.webserver.start();
    }

    private static void printHelp() {
        System.out.println("=== XMLRPC BridgeBuilder ");
        System.out.println("     -remotehost:localhost (client hostname)\n");
        System.out.println("     -remoteport:9009 (client service port)\n");
        System.out.println("     -javaport:9010 (my service port)");
    }

    private static Object[] cdr(Vector v) {
        return XMLRPC_JBServer.cdr(v, 1);
    }

    private static Object[] cdr(Vector v, int skip) {
        Object[] ret = new Object[v.size() - skip];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = v.elementAt(i + skip);
        }
        return ret;
    }

    private static String pid2str(Object pid) {
        return pid.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

