/*
 * Decompiled with CFR 0.152.
 */
package jbridge;

import jbridge.BridgeServer;
import jbridge.IBridgeBuilder;
import jp.gr.java_conf.ccs2.core.AppContextClass;
import jp.gr.java_conf.ccs2.core.DefaultMonitor;

public class BridgeBuilder
extends AppContextClass {
    public static void main(String[] args) {
        if (args.length == 1 && "-h".equals(args[0])) {
            BridgeBuilder.printHelp();
            return;
        }
        try {
            new BridgeBuilder(args).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            BridgeBuilder.errorExit(e.getClass().getName() + " : " + e.getMessage());
        }
    }

    private static void errorExit(String message) {
        System.err.println("Startup failed. : " + message);
        System.exit(0);
    }

    protected BridgeBuilder(String[] args) {
        super(args);
        ((DefaultMonitor)this.getMonitor()).setFormat("%message%");
    }

    protected void start() throws Exception {
        this.getMonitor().debug("Start main routine.");
        this.startupServer();
        System.out.println("OK.");
    }

    private IBridgeBuilder getBridgeBuilder() throws Exception {
        Class<?> c = Class.forName(this.getConfig().getArgumentFile());
        return (IBridgeBuilder)c.newInstance();
    }

    private void startupServer() throws Exception {
        IBridgeBuilder builder = this.getBridgeBuilder();
        builder.setConfig(this.getMonitor(), this.getConfig());
        BridgeServer server = new BridgeServer(this.getMonitor(), builder.getOverrideCaller(), builder.getObjectTransformer());
        builder.start(server);
    }

    private static void printHelp() {
        System.out.println("> java jbridge.BridgeBuilder (bridge builder classname)");
    }
}

