/*
 * Decompiled with CFR 0.152.
 */
package jbridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.gr.java_conf.ccs2.core.MessageMonitor;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class CodeGenerator {
    private HashMap codeTable = new HashMap();
    private Map defaultMap;
    private MessageMonitor monitor;
    private Pattern header = Pattern.compile("^###+[^#](.*)$");
    private Pattern comment = Pattern.compile("^//.*$");

    CodeGenerator(MessageMonitor m, Map dm) throws IOException {
        this.monitor = m;
        this.defaultMap = dm;
        this.load();
    }

    private void load() throws IOException {
        String line;
        InputStream is = this.getClass().getResourceAsStream("/jbridge/code.txt");
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuffer codeBuffer = null;
        String id = null;
        while ((line = in.readLine()) != null) {
            if (this.comment.matcher(line).find()) continue;
            Matcher m = this.header.matcher(line);
            if (m.find()) {
                if (codeBuffer != null) {
                    if (id == null) {
                        throw new RuntimeException("Can not found id.");
                    }
                    this.codeTable.put(id, codeBuffer.toString());
                    this.monitor.debug("CodeGen: " + id);
                }
                id = m.group(1).trim();
                codeBuffer = new StringBuffer();
                continue;
            }
            if (codeBuffer == null) continue;
            codeBuffer.append(line).append("\n");
        }
        this.codeTable.put(id, codeBuffer.toString());
        this.monitor.debug("CG: " + id);
        in.close();
    }

    public String getCode(String id) {
        return this.getCode(id, null);
    }

    public String getCode(String id, String key, String val) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(key, val);
        return this.getCode(id, map);
    }

    public String getCode(String id, Map replaceHash) {
        String ret = (String)this.codeTable.get(id);
        if (ret == null) {
            throw new RuntimeException("BUG: Not found code: " + id);
        }
        ret = this.apply(ret, this.defaultMap);
        return this.apply(ret, replaceHash);
    }

    private String apply(String source, Map m) {
        if (m == null) {
            return source;
        }
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            String pre = (String)it.next();
            String post = (String)m.get(pre);
            source = StringUtil.replace(source, "%" + pre + "%", post);
        }
        return source;
    }
}

