/*
 * Decompiled with CFR 0.152.
 */
package jbridge;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import jp.gr.java_conf.ccs2.core.DefaultMonitor;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class InvocationPool {
    private int maxJob = 4;
    private LinkedList jobQueue = new LinkedList();
    private Worker[] workers;
    private MessageMonitor monitor;

    public InvocationPool(MessageMonitor mon, int maxWorker, int maxJob) {
        this.maxJob = maxJob;
        this.monitor = mon;
        this.workers = new Worker[maxWorker];
        for (int i = 0; i < maxWorker; ++i) {
            this.workers[i] = new Worker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokes(Runnable job) {
        this.monitor.debug("IPool:  Job coming : " + job.toString());
        while (true) {
            LinkedList linkedList = this.jobQueue;
            synchronized (linkedList) {
                if (this.jobQueue.size() < this.maxJob) {
                    this.jobQueue.add(job);
                    this.jobQueue.notifyAll();
                    break;
                }
                try {
                    this.monitor.debug("IPool:  waiting for queue... ");
                    this.jobQueue.wait();
                }
                catch (InterruptedException e) {
                    this.monitor.recordStackTrace(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].finish();
        }
        LinkedList linkedList = this.jobQueue;
        synchronized (linkedList) {
            this.jobQueue.notifyAll();
        }
    }

    public static void main(String[] args) {
        int num = 1000;
        DefaultMonitor mon = new DefaultMonitor();
        long threadTime = 0L;
        long poolTime = 0L;
        long single = 0L;
        int maxjob = 100;
        int maxworker = 10;
        InvocationPool pool = new InvocationPool(mon, maxworker, maxjob);
        for (int i = 0; i < 3; ++i) {
            System.out.println("Thread");
            System.out.println("" + (threadTime += InvocationPool.testThread(num, mon)));
            System.out.println("Pool");
            System.out.println("" + (poolTime += InvocationPool.testPool(num, pool, mon)));
            System.out.println("Single");
            System.out.println("" + (single += InvocationPool.testSingle(num, mon)));
            System.out.println("##");
        }
        System.out.println("-----------------------");
        System.out.println("Thread test");
        System.out.println("" + threadTime);
        System.out.println("Pool   test");
        System.out.println("" + poolTime);
        System.out.println("Single test");
        System.out.println("" + single);
        pool.dispose();
    }

    private static long testPool(int num, InvocationPool pool, MessageMonitor mon) {
        LinkedList results = new LinkedList();
        Runnable[] jobs = InvocationPool.makeJobs(results, num, mon);
        long start = System.currentTimeMillis();
        for (int i = 0; i < jobs.length; ++i) {
            pool.invokes(jobs[i]);
        }
        InvocationPool.wait(results, num, mon);
        return System.currentTimeMillis() - start;
    }

    private static long testThread(int num, MessageMonitor mon) {
        LinkedList results = new LinkedList();
        Runnable[] jobs = InvocationPool.makeJobs(results, num, mon);
        long start = System.currentTimeMillis();
        for (int i = 0; i < jobs.length; ++i) {
            new Thread(jobs[i]).start();
        }
        InvocationPool.wait(results, num, mon);
        return System.currentTimeMillis() - start;
    }

    private static long testSingle(int num, MessageMonitor mon) {
        LinkedList results = new LinkedList();
        Runnable[] jobs = InvocationPool.makeJobs(results, num, mon);
        long start = System.currentTimeMillis();
        for (int i = 0; i < jobs.length; ++i) {
            jobs[i].run();
        }
        InvocationPool.wait(results, num, mon);
        return System.currentTimeMillis() - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wait(List results, int num, MessageMonitor mon) {
        while (true) {
            List list = results;
            synchronized (list) {
                if (results.size() == num) {
                    break;
                }
                try {
                    results.wait();
                }
                catch (InterruptedException e) {
                    mon.recordStackTrace(e);
                }
            }
        }
    }

    private static Runnable[] makeJobs(List rs, int jobs, MessageMonitor m) {
        final List results = rs;
        MessageMonitor mon = m;
        Runnable[] ret = new Runnable[jobs];
        int wait = 100000;
        for (int i = 0; i < jobs; ++i) {
            final int aaa = i;
            ret[i] = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int timer = (int)(Math.random() * 100.0);
                    for (int i = 0; i < timer; ++i) {
                        Date d = new Date(System.currentTimeMillis() - (long)(Math.random() * 1000000.0));
                        String a = d.toString();
                        a.length();
                    }
                    List list = results;
                    synchronized (list) {
                        results.add(new Integer(aaa));
                        results.notify();
                    }
                }
            };
        }
        return ret;
    }

    private class Worker {
        private boolean[] finishFlag = new boolean[]{false};
        private Thread thread = new Thread(new Runnable(this){
            private final /* synthetic */ Worker this$1;
            {
                this.this$1 = this$1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Worker.access$000(this.this$1);
                }
                catch (Throwable t) {
                    InvocationPool.access$200(Worker.access$100(this.this$1)).recordStackTrace(t);
                }
                finally {
                    InvocationPool.access$200(Worker.access$100(this.this$1)).verbose("InvocationPool: thread finished.");
                }
            }
        });

        Worker() {
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finish() {
            boolean[] blArray = this.finishFlag;
            synchronized (this.finishFlag) {
                this.finishFlag[0] = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void workloop() {
            while (true) {
                Runnable job = null;
                Object object = InvocationPool.this.jobQueue;
                // MONITORENTER : object
                if (InvocationPool.this.jobQueue.size() > 0) {
                    job = (Runnable)InvocationPool.this.jobQueue.removeFirst();
                    InvocationPool.this.jobQueue.notifyAll();
                } else {
                    try {
                        InvocationPool.this.jobQueue.wait();
                    }
                    catch (InterruptedException e) {
                        InvocationPool.this.monitor.recordStackTrace(e);
                    }
                }
                // MONITOREXIT : object
                if (job != null) {
                    job.run();
                }
                object = this.finishFlag;
                // MONITORENTER : this.finishFlag
                if (this.finishFlag[0]) {
                    // MONITOREXIT : object
                    return;
                }
                // MONITOREXIT : object
            }
        }

        static /* synthetic */ void access$000(Worker x0) {
            x0.workloop();
        }

        static /* synthetic */ InvocationPool access$100(Worker x0) {
            return x0.InvocationPool.this;
        }
    }
}

