/*
 * Decompiled with CFR 0.152.
 */
package jbridge;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jbridge.Utils;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class MethodFinder {
    private MessageMonitor monitor;
    private HashMap publicClassTable = new HashMap();
    private HashMap allClassTable = new HashMap();
    private AbstractFinder allfinder = new AbstractFinder(){

        List getMethods(Class cls) {
            Method[] ret = cls.getDeclaredMethods();
            ArrayList<Method> list = new ArrayList<Method>();
            for (int i = 0; i < ret.length; ++i) {
                if ((ret[i].getModifiers() & 8) != 0) continue;
                list.add(ret[i]);
            }
            return list;
        }
    };
    private AbstractFinder publicFinder = new AbstractFinder(){

        List getMethods(Class cls) {
            Method[] ret = cls.getDeclaredMethods();
            ArrayList<Method> list = new ArrayList<Method>();
            for (int i = 0; i < ret.length; ++i) {
                int mod = ret[i].getModifiers();
                if (!((mod & 8) == 0 & (mod & 1) > 0)) continue;
                list.add(ret[i]);
            }
            return list;
        }
    };
    private AbstractFinder staticFinder = new AbstractFinder(){

        List getMethods(Class cls) {
            Method[] ret = cls.getDeclaredMethods();
            ArrayList<Method> list = new ArrayList<Method>();
            for (int i = 0; i < ret.length; ++i) {
                if ((ret[i].getModifiers() & 8) <= 0) continue;
                list.add(ret[i]);
            }
            return list;
        }
    };
    static /* synthetic */ Class class$java$util$RandomAccess;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Boolean;

    public MethodFinder(MessageMonitor mon) {
        this.monitor = mon;
    }

    public Constructor searchConstructur(Class cls, Object[] args) throws NoSuchMethodException {
        Constructor<?>[] cs = cls.getConstructors();
        if (cs == null || cs.length == 0) {
            throw new NoSuchMethodException("No declared constructor.");
        }
        if (args == null) {
            args = new Object[]{};
        }
        for (int i = 0; i < cs.length; ++i) {
            if (!this.isMatched(cs[i], args)) continue;
            return cs[i];
        }
        return cls.getConstructor(Utils.object2class(args));
    }

    private boolean isMatched(Constructor constructor, Object[] args) {
        return this.compareParams(constructor.getParameterTypes(), args);
    }

    public Method searchStaticMethod(Class cls, String name, Object[] args) throws NoSuchMethodException {
        if (args == null) {
            args = new Object[]{};
        }
        Utils.writeArguments(this.monitor, 0, "MF:SearchStaticMethod:" + cls.getName() + "." + name, args);
        Method m = this.searchMethodRecursive(cls, name, args, this.publicClassTable, this.staticFinder);
        if (m != null) {
            return m;
        }
        throw new NoSuchMethodException("Not found static method => " + cls.getName() + "#" + name + Utils.makeArgumentExp(args));
    }

    public Method searchPublicMethod(Class cls, String name, Object[] args) throws NoSuchMethodException {
        if (args == null) {
            args = new Object[]{};
        }
        Utils.writeArguments(this.monitor, 0, "MF:SearchPublicMethod:" + cls.getName() + "." + name, args);
        Method m = this.searchMethodRecursive(cls, name, args, this.publicClassTable, this.publicFinder);
        if (m != null) {
            return m;
        }
        throw new NoSuchMethodException("Not found public instance method => " + cls.getName() + "#" + name + Utils.makeArgumentExp(args));
    }

    public Method searchAllMethod(Class cls, String name, Object[] args) throws NoSuchMethodException {
        if (args == null) {
            args = new Object[]{};
        }
        Utils.writeArguments(this.monitor, 0, "MF:SearchAllMethod:" + cls.getName() + "." + name, args);
        Method m = this.searchMethodRecursive(cls, "__org__" + name, args, this.allClassTable, this.allfinder);
        if (m != null) {
            return m;
        }
        throw new NoSuchMethodException("Not found instance method => " + cls.getName() + "#" + name + Utils.makeArgumentExp(args));
    }

    private Method searchMethodRecursive(Class cls, String name, Object[] args, HashMap classMap, AbstractFinder finder) throws NoSuchMethodException {
        int i;
        if (cls == null) {
            return null;
        }
        this.monitor.debug("MF:Searching : " + cls.getName());
        if (!this.ignoreClass(cls)) {
            Method[] ms = this.getMethodsGen(cls, name, classMap, finder);
            for (i = 0; i < ms.length; ++i) {
                if (!this.isMatched(ms[i], args)) continue;
                this.monitor.debug("MF:   Found");
                return ms[i];
            }
        }
        Class<?>[] ifs = cls.getInterfaces();
        for (i = 0; i < ifs.length; ++i) {
            Method m = this.searchMethodRecursive(ifs[i], name, args, classMap, finder);
            if (m == null) continue;
            return m;
        }
        return this.searchMethodRecursive(cls.getSuperclass(), name, args, classMap, finder);
    }

    private boolean ignoreClass(Class c) {
        return (c.getModifiers() & 1) == 0 || c == (class$java$util$RandomAccess == null ? (class$java$util$RandomAccess = MethodFinder.class$("java.util.RandomAccess")) : class$java$util$RandomAccess) || c == (class$java$io$Serializable == null ? (class$java$io$Serializable = MethodFinder.class$("java.io.Serializable")) : class$java$io$Serializable);
    }

    private Method[] getMethodsGen(Class cls, String name, HashMap classMap, AbstractFinder finder) {
        Object ms;
        HashMap<String, Method[]> mmap = (HashMap<String, Method[]>)classMap.get(cls);
        if (mmap == null) {
            mmap = new HashMap<String, Method[]>();
            classMap.put(cls, mmap);
            this.monitor.debug("MF. class cache miss: " + cls.getName());
        } else {
            ms = (Method[])mmap.get(name);
            if (ms != null) {
                return ms;
            }
            Utils.writeArray(this.monitor, 0, new Object[]{"MF. method cache miss: ", cls.getName(), ".", name});
        }
        ms = finder.getMethods(cls);
        LinkedList<Method> list = new LinkedList<Method>();
        for (int i = 0; i < ms.size(); ++i) {
            Method m = (Method)ms.get(i);
            if ((m.getModifiers() & 2) > 0 || !m.getName().equals(name)) continue;
            list.add(m);
        }
        Method[] rms = list.toArray(new Method[list.size()]);
        mmap.put(name, rms);
        return rms;
    }

    private boolean isMatched(Method method, Object[] args) {
        return this.compareParams(method.getParameterTypes(), args);
    }

    private boolean compareParams(Class[] types, Object[] args) {
        if (args.length != types.length) {
            return false;
        }
        if (args.length == 0 && types.length == 0) {
            return true;
        }
        for (int j = 0; j < args.length; ++j) {
            Object a = args[j];
            Class t = types[j];
            if (t.isInstance(args[j])) continue;
            if (t.isPrimitive() && a == null) {
                return false;
            }
            if (!t.isPrimitive() && a == null || (t.equals(Boolean.TYPE) || t.equals(class$java$lang$Boolean == null ? MethodFinder.class$("java.lang.Boolean") : class$java$lang$Boolean)) && a.getClass().equals(class$java$lang$Boolean == null ? MethodFinder.class$("java.lang.Boolean") : class$java$lang$Boolean) || a instanceof Number && this.canConvert(j, args, t)) continue;
            return false;
        }
        return true;
    }

    private boolean canConvert(int j, Object[] args, Class type) {
        Object a = args[j];
        Object ret = Utils.convertObjectType(a, type);
        if (ret == null) {
            return false;
        }
        args[j] = ret;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private abstract class AbstractFinder {
        private AbstractFinder() {
        }

        abstract List getMethods(Class var1);
    }
}

