/*
 * Decompiled with CFR 0.152.
 */
package jbridge;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassMap;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import jbridge.ClassFinder;
import jbridge.CodeGenerator;
import jbridge.IObjectTransformer;
import jbridge.MethodFinder;
import jbridge.ObjectRegistry;
import jbridge.SessionManager;
import jbridge.Utils;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class ObjectManager {
    private static String FIELD_OBJECT_SUPERCLASS = "__super";
    private static String FIELD_OBJECT_ID = "__objectId";
    private static String FIELD_METHOD_FINDER = "__methodFinder";
    private static String FIELD_SESSION_MANAGER = "__sessionManager";
    static String FIELD_IMPL_FLAG_PREFIX = "__impl_";
    static final String METHOD_SEND_MESSAGE = "__sendMessage";
    static final String METHOD_ORG_PREFIX = "__org__";
    static final String METHOD_SUPERCLASS_METHOD = "__callSuperclassMethod";
    static final String METHOD_INJECT_FIELDS = "__injectFields";
    private MessageMonitor monitor;
    private CodeGenerator codegen;
    private ClassFinder classFinder;
    private IObjectTransformer transformer;
    private MethodFinder methodFinder;
    private ClassPool pool = ClassPool.getDefault();
    private SessionManager sessionManager;
    private ObjectRegistry objectRegistry = new ObjectRegistry();
    private static int currentExtendId = 0;

    private static synchronized String makeUniqueClassname(String hint) {
        return "JBCustomClass" + ++currentExtendId;
    }

    public ObjectManager(MessageMonitor mon, SessionManager rb, IObjectTransformer ot) {
        this.monitor = mon;
        this.sessionManager = rb;
        this.transformer = ot;
        this.classFinder = new ClassFinder(mon);
        this.methodFinder = new MethodFinder(mon);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("f_super", FIELD_OBJECT_SUPERCLASS);
        map.put("f_id", FIELD_OBJECT_ID);
        map.put("f_mfinder", FIELD_METHOD_FINDER);
        map.put("f_session", FIELD_SESSION_MANAGER);
        map.put("f_impl_prefix", FIELD_IMPL_FLAG_PREFIX);
        map.put("m_inject", METHOD_INJECT_FIELDS);
        map.put("m_org_prefix", METHOD_ORG_PREFIX);
        map.put("m_send", METHOD_SEND_MESSAGE);
        map.put("m_super", METHOD_SUPERCLASS_METHOD);
        try {
            this.codegen = new CodeGenerator(this.monitor, map);
        }
        catch (Throwable e) {
            this.monitor.recordStackTrace(e);
            this.monitor.error("BUG: Can not read template code.");
            System.exit(1);
        }
    }

    public Object createObject(String cn, Object[] args) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class cl = this.classFinder.findClass(cn);
        if (this.isAbstract(cl)) {
            throw new RuntimeException("Can not instantiate abstract class. : " + cn);
        }
        return this.getInstanceId(cl, args);
    }

    public Object extendObject(String cns, Object[] args) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object id = this.getInstanceId(this.buildClass(cns), args);
        Object obj = this.objectRegistry.getObject(id);
        this.injectParams(obj, id);
        return id;
    }

    public Object staticReference(String cn) throws ClassNotFoundException {
        Class cl = this.classFinder.findClass(cn);
        return this.objectRegistry.registerObject(cl);
    }

    public void addImport(String lines) {
        this.classFinder.addImport(lines);
    }

    public Object getObject(Object key) {
        return this.objectRegistry.getObject(key);
    }

    public void removeObject(Object key) {
        this.objectRegistry.removeObject(key);
    }

    public boolean isKey(Object key) {
        return this.objectRegistry.isKey(key);
    }

    public Object[] getAllObjectKeys() {
        return this.objectRegistry.getAllObjectKeys();
    }

    public String inspectClassnameByKey(Object key) {
        Object obj = this.objectRegistry.getObject(key);
        if (obj == null) {
            return null;
        }
        return this.inspectClassname(obj);
    }

    public String inspectClassname(Object obj) {
        if (obj instanceof Class) {
            return ((Class)obj).getName();
        }
        return obj.getClass().getName();
    }

    private Object getInstanceId(Class cl, Object[] args) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object obj = null;
        if (args == null || args.length == 0) {
            obj = cl.newInstance();
        } else {
            Constructor cnst = this.methodFinder.searchConstructur(cl, args);
            obj = cnst.newInstance(args);
        }
        Object id = this.objectRegistry.registerObject(obj);
        this.monitor.debug("OM::createObject  key:" + id + ", class:" + cl.getName());
        return id;
    }

    private boolean isAbstract(Class cl) {
        return (cl.getModifiers() & 0x400) > 0 || (cl.getModifiers() & 0x200) > 0;
    }

    private void injectParams(Object obj, Object key) {
        try {
            Object[] args = new Object[]{key, this.sessionManager, this.methodFinder};
            Method m = this.methodFinder.searchPublicMethod(obj.getClass(), METHOD_INJECT_FIELDS, args);
            m.invoke(obj, args);
            this.monitor.debug("injected object ID [" + key + "] and SessionManager [" + this.sessionManager + "].");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("BUG: Can not inject fields. ", e);
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private Class buildClass(String _cns) throws ClassNotFoundException {
        CtClass cc = this.makeClass(_cns);
        ClassMap classmap = null;
        try {
            this.addConstructor(cc, classmap);
            this.addCustomFields(cc);
            this.addImplFlags(cc);
            this.addSendMessageMethod(cc);
            this.addSuperClassMethodCaller(cc);
            this.addOrgMethods(cc, classmap);
            this.addOverrideMethods(cc, classmap);
            return cc.toClass();
        }
        catch (CannotCompileException e) {
            this.monitor.recordStackTrace(e);
            this.monitor.error("BUG.");
            System.exit(0);
            return null;
        }
    }

    private static HashMap makeMap(String k1, String v1) {
        return ObjectManager.makeMap(new String[]{k1, v1});
    }

    private static HashMap makeMap(String[] source) {
        int i = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        while (i < source.length) {
            map.put(source[i++], source[i++]);
        }
        return map;
    }

    private void addConstructor(CtClass cc, ClassMap classmap) throws CannotCompileException {
        cc.addConstructor(CtNewConstructor.defaultConstructor((CtClass)cc));
        CtClass superclass = null;
        try {
            superclass = cc.getSuperclass();
            if (superclass == null) {
                return;
            }
        }
        catch (NotFoundException e) {
            this.monitor.recordStackTrace(e);
            return;
        }
        CtConstructor[] inits = superclass.getConstructors();
        this.monitor.debug("===add constructor: " + inits.length);
        for (int i = 0; i < inits.length; ++i) {
            CtConstructor copy = null;
            try {
                copy = CtNewConstructor.make((CtClass[])this.getParamList((CtBehavior)inits[i], cc), (CtClass[])inits[i].getExceptionTypes(), (CtClass)cc);
                copy.setBody(this.codegen.getCode("SuperConstructor"));
                cc.addConstructor(copy);
                this.monitor.debug("  Add:Constructor:" + copy.toString());
                continue;
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (CannotCompileException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("duplicate method:") >= 0) {
                    this.monitor.debug("    duplicate constructor : " + copy);
                    continue;
                }
                throw e;
            }
        }
    }

    private CtClass[] getParamList(CtBehavior method, CtClass subclass) {
        try {
            CtClass[] list = method.getParameterTypes();
            CtClass superclass = subclass.getSuperclass();
            if (superclass == null) {
                return list;
            }
            return this.replaceParamList(list, subclass, superclass);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private CtClass[] replaceParamList(CtClass[] list, CtClass oldc, CtClass newc) {
        CtClass[] ret = new CtClass[list.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list[i].equals(oldc) ? newc : list[i];
        }
        return ret;
    }

    private CtClass getReturnType(CtMethod method, CtClass subclass) {
        try {
            CtClass ret = method.getReturnType();
            CtClass superclass = subclass.getSuperclass();
            if (superclass == null) {
                return ret;
            }
            return this.replaceParamList(new CtClass[]{ret}, subclass, superclass)[0];
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void addOverrideMethods(CtClass cc, ClassMap classmap) throws CannotCompileException {
        this.monitor.debug("===add override method");
        CtMethod[] ms = this.getOverrideMethod(cc);
        for (int i = 0; i < ms.length; ++i) {
            if (!this.canBeOverrided(ms[i])) continue;
            CtMethod method = null;
            try {
                method = CtNewMethod.make((int)ms[i].getModifiers(), (CtClass)this.getReturnType(ms[i], cc), (String)ms[i].getName(), (CtClass[])this.getParamList((CtBehavior)ms[i], cc), (CtClass[])ms[i].getExceptionTypes(), null, (CtClass)cc);
                HashMap map = ObjectManager.makeMap("name", method.getName());
                String checkCode = "";
                if ((ms[i].getModifiers() & 0x400) == 0) {
                    checkCode = this.codegen.getCode("OverrideMethod_check", null);
                }
                map.put("check", checkCode);
                method.setBody(this.codegen.getCode("OverrideMethod_return", map));
                method.setModifiers(method.getModifiers() & 0xFFFFFBFF);
                cc.addMethod(method);
                this.monitor.debug("  Add:Override:" + method.toString());
                method = null;
                continue;
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (CannotCompileException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("duplicate method:") >= 0) {
                    this.monitor.debug("   duplicate method : " + method);
                    continue;
                }
                throw e;
            }
        }
    }

    private boolean canBeOverrided(CtMethod m) {
        if ("finalize".equals(m.getName())) {
            return false;
        }
        int a = m.getModifiers();
        return (a & 0x11A) <= 0;
    }

    private void addOrgMethods(CtClass cc, ClassMap classmap) throws CannotCompileException {
        this.monitor.debug("===add original method");
        CtMethod[] ms = this.getOverrideMethod(cc);
        for (int i = 0; i < ms.length; ++i) {
            if (!this.doesSaveOriginalMethod(ms[i])) continue;
            CtMethod method = null;
            try {
                HashMap map = ObjectManager.makeMap("name", ms[i].getName());
                method = CtNewMethod.make((int)ms[i].getModifiers(), (CtClass)this.getReturnType(ms[i], cc), (String)(METHOD_ORG_PREFIX + ms[i].getName()), (CtClass[])this.getParamList((CtBehavior)ms[i], cc), (CtClass[])ms[i].getExceptionTypes(), (String)this.codegen.getCode("OriginalMethod", map), (CtClass)cc);
                cc.addMethod(method);
                this.monitor.debug("  Add:Org:" + method.toString());
                method = null;
                continue;
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (CannotCompileException e) {
                this.monitor.warning(((Object)((Object)e)).getClass().getName() + " : " + e.getMessage());
                if (method == null) continue;
                this.monitor.warning("  Problem:" + method.toString());
            }
        }
    }

    private boolean doesSaveOriginalMethod(CtMethod m) {
        if ("finalize".equals(m.getName())) {
            return false;
        }
        int a = m.getModifiers();
        return (a & 0x51A) <= 0;
    }

    private void addImplFlags(CtClass cc) throws CannotCompileException {
        this.monitor.debug("===add implementation flag");
        ArrayList<String> list = new ArrayList<String>();
        CtMethod[] ms = this.getOverrideMethod(cc);
        for (int i = 0; i < ms.length; ++i) {
            if (!this.doesSaveOriginalMethod(ms[i])) continue;
            String name = ms[i].getName();
            if (list.contains(name)) {
                this.monitor.debug("    duplicate method: " + name);
                continue;
            }
            list.add(name);
            CtField f = CtField.make((String)this.codegen.getCode("ImplFlagField", "name", name), (CtClass)cc);
            cc.addField(f);
            this.monitor.debug("  Add:Flag:" + f.toString());
        }
    }

    private CtMethod[] getOverrideMethod(CtClass cc) {
        ArrayList list = new ArrayList();
        this.collectMethods(cc.getMethods(), list);
        try {
            while ((cc = cc.getSuperclass()) != null) {
                this.collectMethods(cc.getDeclaredMethods(), list);
            }
        }
        catch (NotFoundException e) {
            this.monitor.recordStackTrace(e);
        }
        return list.toArray(new CtMethod[list.size()]);
    }

    private void collectMethods(CtMethod[] ms, List list) {
        for (int i = 0; i < ms.length; ++i) {
            String name = ms[i].getName();
            if ((ms[i].getModifiers() & 2) > 0 || METHOD_SEND_MESSAGE.equals(name) || METHOD_SUPERCLASS_METHOD.equals(name) || METHOD_INJECT_FIELDS.equals(name) || name.indexOf(METHOD_ORG_PREFIX) == 0 || list.contains(ms[i])) continue;
            list.add(ms[i]);
        }
    }

    private void addCustomFields(CtClass cc) throws CannotCompileException {
        try {
            CtClass sc = cc.getSuperclass();
            if (sc != null) {
                CtField fsp = CtField.make((String)this.codegen.getCode("SuperClassField", "name", sc.getName()), (CtClass)cc);
                cc.addField(fsp);
                this.monitor.debug("  Add:Field:" + fsp.toString());
            }
            CtField frb = CtField.make((String)this.codegen.getCode("SessionManagerField"), (CtClass)cc);
            cc.addField(frb);
            this.monitor.debug("  Add:Field:" + frb.toString());
            CtField fid = CtField.make((String)this.codegen.getCode("IdField"), (CtClass)cc);
            cc.addField(fid);
            this.monitor.debug("  Add:Field:" + fid.toString());
            CtField fmf = CtField.make((String)this.codegen.getCode("MethodFinderField"), (CtClass)cc);
            cc.addField(fmf);
            this.monitor.debug("  Add:Field:" + fmf.toString());
            CtMethod im = CtNewMethod.make((String)this.codegen.getCode("InjectMethod"), (CtClass)cc);
            cc.addMethod(im);
            this.monitor.debug("  Add:Inject:" + im.toString());
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void addSendMessageMethod(CtClass cc) throws CannotCompileException {
        CtMethod gm = CtNewMethod.make((String)this.codegen.getCode("SendMessage"), (CtClass)cc);
        cc.addMethod(gm);
        this.monitor.debug("  Add:Send:" + gm.toString());
    }

    private void addSuperClassMethodCaller(CtClass cc) throws CannotCompileException {
        CtMethod gm = CtNewMethod.make((String)this.codegen.getCode("SuperCaller"), (CtClass)cc);
        cc.addMethod(gm);
        this.monitor.debug("  Add:SuperCaller:" + gm.toString());
    }

    private CtClass makeClass(String _cns) throws ClassNotFoundException {
        Iterator it;
        this.monitor.debug("Generating derived class: " + _cns);
        String[] cns = _cns.split(",");
        CtClass superClass = null;
        LinkedList<CtClass> interfaces = new LinkedList<CtClass>();
        for (int i = 0; i < cns.length; ++i) {
            try {
                CtClass cls = this.pool.get(this.classFinder.fqcn(cns[i]));
                if (cls.isInterface()) {
                    interfaces.add(cls);
                    continue;
                }
                if (superClass != null) {
                    throw new RuntimeException("Given another super class : " + superClass.getName() + " and " + cls.getName());
                }
                superClass = cls;
                continue;
            }
            catch (NotFoundException e) {
                this.monitor.recordStackTrace(e);
                throw new ClassNotFoundException(e.getMessage());
            }
        }
        CtClass cc = null;
        if (superClass != null) {
            cc = this.pool.makeClass(ObjectManager.makeUniqueClassname(superClass.getName()), superClass);
            it = interfaces.iterator();
            while (it.hasNext()) {
                cc.addInterface((CtClass)it.next());
            }
        } else {
            it = interfaces.iterator();
            while (it.hasNext()) {
                CtClass c = (CtClass)it.next();
                if (cc == null) {
                    cc = this.pool.makeClass(ObjectManager.makeUniqueClassname(c.getName()));
                }
                cc.addInterface(c);
            }
        }
        return cc;
    }

    public Object[] obj2ids(Object[] args) {
        Object[] ret = new Object[args.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.obj2id(args[i]);
        }
        return ret;
    }

    public Object obj2id(Object arg) {
        Object targ = this.transformer.exportFilter(arg);
        if (targ != null) {
            return targ;
        }
        if (arg == null) {
            return null;
        }
        if (arg.getClass().isArray()) {
            return this.obj2id_array(arg);
        }
        return this.objectRegistry.registerObject(arg);
    }

    private Object obj2id_array(Object arg) {
        int sz = Array.getLength(arg);
        Object[] ret = new Object[sz];
        for (int i = 0; i < sz; ++i) {
            ret[i] = this.obj2id(Array.get(arg, i));
        }
        return ret;
    }

    public Object[] id2objs(Object[] args) {
        if (args == null) {
            return new Object[0];
        }
        if (args.length == 0) {
            return args;
        }
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.id2obj(args[i]);
        }
        return args;
    }

    public Object id2obj(Object arg) {
        if (arg == null) {
            return null;
        }
        if (this.objectRegistry.isKey(arg)) {
            String pre = arg.getClass().getName();
            arg = this.objectRegistry.getObject(arg);
            Utils.writeArray(this.monitor, 0, new Object[]{"  ARG TR: ", pre, " -> ", arg.getClass().getName()});
            return arg;
        }
        return this.transformer.importFilter(arg);
    }

    public Class findClass(String cn) throws ClassNotFoundException {
        return this.classFinder.findClass(cn);
    }

    public Method searchPublicMethod(Class cls, String name, Object[] args) throws NoSuchMethodException {
        return this.methodFinder.searchPublicMethod(cls, name, args);
    }

    public Method searchAllMethod(Class cls, String name, Object[] args) throws NoSuchMethodException {
        return this.methodFinder.searchAllMethod(cls, name, args);
    }

    public Method searchStaticMethod(Class cls, String name, Object[] args) throws NoSuchMethodException {
        return this.methodFinder.searchStaticMethod(cls, name, args);
    }

    public ClassPool getClassPool() {
        return this.pool;
    }
}

