/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.binstream;

import java.io.IOException;
import java.io.InputStream;
import jbridge.comm.binstream.AbstractTransferObject;
import jbridge.comm.binstream.BinConstants;
import jbridge.comm.binstream.BinDecoder;
import jbridge.comm.binstream.BinStreamException;
import jbridge.comm.binstream.DecodeHandlerClass;
import jbridge.comm.binstream.DecodeHandlerClass2;
import jbridge.comm.binstream.ResultErrObject;
import jbridge.comm.binstream.ResultOkObject;

public abstract class AbstractResultObject
extends AbstractTransferObject
implements BinConstants {
    protected AbstractResultObject(Object _sid) {
        super(_sid);
    }

    public static AbstractResultObject get(InputStream in) throws IOException {
        DecodeHandlerClass2 ret = new DecodeHandlerClass2();
        BinDecoder.read(in, ret);
        Object sid = ret.value;
        final int[] mcode = new int[]{0};
        BinDecoder.read(in, new DecodeHandlerClass(){

            public void readByte(byte c) {
                mcode[0] = c;
            }
        });
        switch (mcode[0]) {
            case 32: {
                BinDecoder.read(in, ret);
                Object value = ret.value;
                return new ResultOkObject(sid, value);
            }
            case 33: 
            case 34: 
            case 35: {
                BinDecoder.read(in, ret);
                String klass = (String)ret.value;
                BinDecoder.read(in, ret);
                String message = (String)ret.value;
                BinDecoder.read(in, ret);
                String detail = (String)ret.value;
                return new ResultErrObject(sid, mcode[0], klass, message, detail);
            }
        }
        throw new RuntimeException("Unknown return code:" + mcode[0]);
    }

    protected byte getMessageType() {
        return 1;
    }

    abstract Object getValue() throws BinStreamException, IOException;
}

