/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.binstream;

import java.io.IOException;
import java.net.Socket;
import jbridge.comm.binstream.BinConstants;
import jbridge.comm.binstream.ICommunicator;
import jbridge.comm.binstream.IMessageHandler;
import jbridge.comm.binstream.MessageServer;
import jbridge.comm.binstream.ServiceManager;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class BinClient
implements BinConstants,
ICommunicator {
    private MessageMonitor monitor;
    private String host;
    private int port;
    private ServiceManager handlerManager = new ServiceManager();
    private MessageServer messageServer;
    private Thread socketThread;
    private boolean shutdownFlag = false;
    private Runnable connector = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!BinClient.this.shutdownFlag) {
                    try {
                        BinClient.this.monitor.verbose("BinClient: connecting...");
                        Socket socket = new Socket(BinClient.this.host, BinClient.this.port);
                        BinClient.this.monitor.verbose("BinClient: connection established.");
                        BinClient.this.messageServer.setSocket(socket);
                        BinClient.this.messageServer.blockWorkingThread();
                        BinClient.this.monitor.verbose("BinClient: disconnected.");
                    }
                    catch (IOException e) {
                        BinClient.this.monitor.recordStackTrace(e);
                    }
                }
                Object var3_3 = null;
                BinClient.this.monitor.debug("BinClient: Connector thread finished.");
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                BinClient.this.monitor.debug("BinClient: Connector thread finished.");
                BinClient.this.socketThread = null;
                throw throwable;
            }
            BinClient.this.socketThread = null;
        }
    };

    public BinClient(MessageMonitor mon, String host, int port) throws IOException {
        this.monitor = mon;
        this.messageServer = new MessageServer("CL", this.monitor, this.handlerManager);
        this.host = host;
        this.port = port;
    }

    public synchronized void start() {
        this.shutdownFlag = false;
        this.socketThread = new Thread(this.connector);
        this.socketThread.setName("BCL|socket");
        this.socketThread.start();
    }

    public synchronized void shutdown() {
        this.monitor.debug("BinClient: shutdown signal arrived.");
        this.shutdownFlag = true;
        this.messageServer.shutdown();
        while (this.socketThread != null) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                this.monitor.recordStackTrace(e);
                return;
            }
        }
        this.monitor.debug("BinClient: shutdown completed.");
        this.shutdownFlag = false;
    }

    public void addHandler(String name, IMessageHandler h) {
        this.handlerManager.addHandler(name, h);
    }

    public Object send(String name, Object[] args) throws IOException {
        return this.messageServer.send(name, args);
    }

    public void removeHandler(String name) {
        this.handlerManager.removeHandler(name);
    }
}

