/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.binstream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.List;
import jbridge.comm.binstream.BinConstants;
import jbridge.comm.binstream.BinStreamException;

public class BinEncoder
implements BinConstants {
    public static final int write(OutputStream out, boolean a) throws IOException {
        out.write(a ? 27 : 28);
        return 2;
    }

    public static final int write(OutputStream out, byte a) throws IOException {
        out.write(17);
        out.write(a);
        return 2;
    }

    public static final int write(OutputStream out, short a) throws IOException {
        out.write(18);
        return 1 + BinEncoder.writeInt2(out, a);
    }

    public static final int write(OutputStream out, int a) throws IOException {
        out.write(19);
        return 1 + BinEncoder.writeInt4(out, a);
    }

    private static final int writeInt4(OutputStream out, int a) throws IOException {
        out.write(a & 0xFF);
        out.write(a >> 8 & 0xFF);
        out.write(a >> 16 & 0xFF);
        out.write(a >> 24 & 0xFF);
        return 4;
    }

    private static final int writeInt2(OutputStream out, int a) throws IOException {
        out.write(a & 0xFF);
        out.write(a >> 8 & 0xFF);
        return 2;
    }

    public static final int write(OutputStream out, long a) throws IOException {
        out.write(20);
        return 1 + BinEncoder.writeLong(out, a);
    }

    private static final int l2b(long a) {
        return (int)(a & 0xFFL);
    }

    private static final int writeLong(OutputStream out, long a) throws IOException {
        out.write(BinEncoder.l2b(a));
        out.write(BinEncoder.l2b(a >> 8));
        out.write(BinEncoder.l2b(a >> 16));
        out.write(BinEncoder.l2b(a >> 24));
        out.write(BinEncoder.l2b(a >> 32));
        out.write(BinEncoder.l2b(a >> 40));
        out.write(BinEncoder.l2b(a >> 48));
        out.write(BinEncoder.l2b(a >> 56));
        return 8;
    }

    public static final int write(OutputStream out, float a) throws IOException {
        out.write(21);
        return 1 + BinEncoder.writeInt4(out, Float.floatToIntBits(a));
    }

    public static final int write(OutputStream out, double a) throws IOException {
        out.write(22);
        return 1 + BinEncoder.writeLong(out, Double.doubleToLongBits(a));
    }

    private static final int writeString(OutputStream out, String a) throws IOException {
        if (a == null) {
            BinEncoder.writeInt4(out, -1);
            return 4;
        }
        byte[] ret = null;
        try {
            ret = a.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            ret = a.getBytes();
        }
        BinEncoder.writeInt4(out, ret.length);
        out.write(ret);
        return 4 + ret.length;
    }

    public static final int write(OutputStream out, BigDecimal a) throws IOException {
        if (a == null) {
            return BinEncoder.writeNull(out);
        }
        out.write(23);
        return 1 + BinEncoder.writeString(out, a.toString());
    }

    public static final int write(OutputStream out, String a) throws IOException {
        if (a == null) {
            return BinEncoder.writeNull(out);
        }
        out.write(24);
        return 1 + BinEncoder.writeString(out, a);
    }

    public static final int writeObject(OutputStream out, Object obj) throws IOException {
        if (obj == null) {
            return BinEncoder.writeNull(out);
        }
        if (obj instanceof Boolean) {
            return BinEncoder.write(out, Boolean.TRUE.equals(obj));
        }
        if (obj instanceof String) {
            return BinEncoder.write(out, (String)obj);
        }
        if (obj instanceof Number) {
            return BinEncoder.writeNumber(out, (Number)obj);
        }
        if (obj instanceof int[]) {
            return BinEncoder.write(out, (int[])obj);
        }
        if (obj instanceof double[]) {
            return BinEncoder.write(out, (double[])obj);
        }
        if (obj instanceof byte[]) {
            return BinEncoder.write(out, (byte[])obj);
        }
        if (obj instanceof String[]) {
            return BinEncoder.write(out, (String[])obj);
        }
        if (obj instanceof short[]) {
            return BinEncoder.write(out, (short[])obj);
        }
        if (obj instanceof float[]) {
            return BinEncoder.write(out, (float[])obj);
        }
        if (obj instanceof BigDecimal[]) {
            return BinEncoder.write(out, (BigDecimal[])obj);
        }
        if (obj instanceof Object[]) {
            return BinEncoder.writeList(out, (Object[])obj);
        }
        if (obj instanceof List) {
            return BinEncoder.writeList(out, ((List)obj).toArray());
        }
        throw new BinStreamException("Can not write the object: " + obj.getClass().getName());
    }

    public static final int writeNumber(OutputStream out, Number obj) throws IOException {
        if (obj == null) {
            return BinEncoder.writeNull(out);
        }
        if (obj instanceof Integer) {
            return BinEncoder.write(out, obj.intValue());
        }
        if (obj instanceof Double) {
            return BinEncoder.write(out, obj.doubleValue());
        }
        if (obj instanceof Byte) {
            return BinEncoder.write(out, obj.byteValue());
        }
        if (obj instanceof Long) {
            return BinEncoder.write(out, obj.longValue());
        }
        if (obj instanceof Short) {
            return BinEncoder.write(out, obj.shortValue());
        }
        if (obj instanceof Float) {
            return BinEncoder.write(out, obj.floatValue());
        }
        if (obj instanceof BigDecimal) {
            return BinEncoder.write(out, (BigDecimal)obj);
        }
        throw new BinStreamException("Can not write the object: " + obj.getClass().getName() + " : " + obj.toString());
    }

    public static final int writeNull(OutputStream out) throws IOException {
        out.write(16);
        return 1;
    }

    public static final int write(OutputStream out, boolean[] obj) throws IOException {
        out.write(25);
        out.write(27);
        BinEncoder.writeInt4(out, obj.length);
        for (int i = 0; i < obj.length; ++i) {
            out.write(obj[i] ? 27 : 28);
        }
        return 6 + obj.length;
    }

    public static final int write(OutputStream out, byte[] obj) throws IOException {
        out.write(25);
        out.write(17);
        BinEncoder.writeInt4(out, obj.length);
        out.write(obj);
        return 6 + obj.length;
    }

    public static final int write(OutputStream out, short[] obj) throws IOException {
        out.write(25);
        out.write(18);
        BinEncoder.writeInt4(out, obj.length);
        for (int i = 0; i < obj.length; ++i) {
            BinEncoder.writeInt2(out, obj[i]);
        }
        return 6 + obj.length * 2;
    }

    public static final int write(OutputStream out, int[] obj) throws IOException {
        out.write(25);
        out.write(19);
        BinEncoder.writeInt4(out, obj.length);
        for (int i = 0; i < obj.length; ++i) {
            BinEncoder.writeInt4(out, obj[i]);
        }
        return 6 + obj.length * 4;
    }

    public static final int write(OutputStream out, long[] obj) throws IOException {
        out.write(25);
        out.write(20);
        BinEncoder.writeInt4(out, obj.length);
        for (int i = 0; i < obj.length; ++i) {
            BinEncoder.writeLong(out, obj[i]);
        }
        return 6 + obj.length * 8;
    }

    public static final int write(OutputStream out, float[] obj) throws IOException {
        out.write(25);
        out.write(21);
        BinEncoder.writeInt4(out, obj.length);
        for (int i = 0; i < obj.length; ++i) {
            BinEncoder.writeInt4(out, Float.floatToIntBits(obj[i]));
        }
        return 6 + obj.length * 4;
    }

    public static final int write(OutputStream out, double[] obj) throws IOException {
        out.write(25);
        out.write(22);
        BinEncoder.writeInt4(out, obj.length);
        for (int i = 0; i < obj.length; ++i) {
            BinEncoder.writeLong(out, Double.doubleToLongBits(obj[i]));
        }
        return 6 + obj.length * 8;
    }

    public static final int write(OutputStream out, String[] obj) throws IOException {
        out.write(25);
        out.write(24);
        BinEncoder.writeInt4(out, obj.length);
        int size = 6;
        for (int i = 0; i < obj.length; ++i) {
            size += BinEncoder.writeString(out, obj[i]);
        }
        return size;
    }

    public static final int write(OutputStream out, BigDecimal[] obj) throws IOException {
        out.write(25);
        out.write(23);
        BinEncoder.writeInt4(out, obj.length);
        int size = 6;
        for (int i = 0; i < obj.length; ++i) {
            size += BinEncoder.writeString(out, obj[i].toString());
        }
        return size;
    }

    public static final int writeList(OutputStream out, Object[] obj) throws IOException {
        out.write(26);
        BinEncoder.writeInt4(out, obj.length);
        int size = 5;
        for (int i = 0; i < obj.length; ++i) {
            Object a = obj[i];
            if (a == null) {
                size += BinEncoder.writeNull(out);
                continue;
            }
            if (a instanceof Number) {
                size += BinEncoder.writeNumber(out, (Number)a);
                continue;
            }
            if (a instanceof String) {
                size += BinEncoder.write(out, (String)a);
                continue;
            }
            if (a instanceof int[]) {
                size += BinEncoder.write(out, (int[])a);
                continue;
            }
            if (a instanceof double[]) {
                size += BinEncoder.write(out, (double[])a);
                continue;
            }
            if (a instanceof byte[]) {
                size += BinEncoder.write(out, (byte[])a);
                continue;
            }
            if (a instanceof String[]) {
                size += BinEncoder.write(out, (String[])a);
                continue;
            }
            if (a instanceof short[]) {
                size += BinEncoder.write(out, (short[])a);
                continue;
            }
            if (a instanceof float[]) {
                size += BinEncoder.write(out, (float[])a);
                continue;
            }
            if (a instanceof BigDecimal[]) {
                size += BinEncoder.write(out, (BigDecimal[])a);
                continue;
            }
            if (a instanceof Boolean) {
                size += BinEncoder.write(out, Boolean.TRUE.equals(a));
                continue;
            }
            if (a instanceof boolean[]) {
                size += BinEncoder.write(out, (boolean[])a);
                continue;
            }
            if (a instanceof Object[]) {
                size += BinEncoder.writeList(out, (Object[])a);
                continue;
            }
            if (a instanceof List) {
                size += BinEncoder.writeList(out, ((List)a).toArray());
                continue;
            }
            throw new BinStreamException("Can not write the object: " + obj.getClass().getName());
        }
        return size;
    }
}

