/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.binstream;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import jbridge.comm.binstream.BinConstants;
import jbridge.comm.binstream.ICommunicator;
import jbridge.comm.binstream.IMessageHandler;
import jbridge.comm.binstream.MessageServer;
import jbridge.comm.binstream.ServiceManager;
import jp.gr.java_conf.ccs2.core.DefaultMonitor;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class BinServer
implements BinConstants,
ICommunicator {
    private MessageMonitor monitor;
    private ServerSocket serverSocket;
    private ServiceManager handlerManager = new ServiceManager();
    private MessageServer messageServer;
    private Thread socketThread;
    private boolean shutdownFlag = false;
    private Runnable acceptor = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!BinServer.this.shutdownFlag) {
                    Object s = null;
                    try {
                        BinServer.this.monitor.verbose("BinServer: waiting for client's connection...");
                        BinServer.this.messageServer.setSocket(BinServer.this.waitingForClientConnection(BinServer.this.serverSocket));
                        BinServer.this.monitor.verbose("BinServer: connection established.");
                        BinServer.this.messageServer.blockWorkingThread();
                        BinServer.this.monitor.verbose("BinServer: disconnected.");
                    }
                    catch (SocketTimeoutException e) {
                    }
                    catch (IOException e) {
                        BinServer.this.monitor.recordStackTrace(e);
                        Object var4_4 = null;
                        BinServer.this.monitor.debug("BinServer: Acceptor thread finished.");
                        BinServer.this.socketThread = null;
                        return;
                    }
                }
                Object var4_5 = null;
                BinServer.this.monitor.debug("BinServer: Acceptor thread finished.");
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                BinServer.this.monitor.debug("BinServer: Acceptor thread finished.");
                BinServer.this.socketThread = null;
                throw throwable;
            }
            BinServer.this.socketThread = null;
        }
    };

    public BinServer(MessageMonitor mon, int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        this.monitor = mon;
        this.messageServer = new MessageServer("SV", this.monitor, this.handlerManager);
    }

    public BinServer(MessageMonitor mon) throws IOException {
        this(mon, 0);
    }

    public int getPortNumber() {
        return this.serverSocket.getLocalPort();
    }

    public void start() {
        this.socketThread = new Thread(this.acceptor);
        this.socketThread.setName("BSV|socket");
        this.socketThread.start();
    }

    public void shutdown() {
        this.monitor.debug("BinServer: shutdown signal arrived.");
        this.shutdownFlag = true;
        this.messageServer.shutdown();
        while (this.socketThread != null) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                this.monitor.recordStackTrace(e);
                return;
            }
        }
        this.monitor.debug("BinServer: shutdown completed.");
    }

    private Socket waitingForClientConnection(ServerSocket ss) throws IOException {
        ss.setSoTimeout(300);
        while (true) {
            try {
                return ss.accept();
            }
            catch (SocketTimeoutException e) {
                if (!this.shutdownFlag) continue;
                throw e;
            }
            break;
        }
    }

    public void addHandler(String name, IMessageHandler h) {
        this.handlerManager.addHandler(name, h);
    }

    public Object send(String name, Object[] args) throws IOException {
        return this.messageServer.send(name, args);
    }

    public void removeHandler(String name) {
        this.handlerManager.removeHandler(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        int level = 1;
        if (args.length > 1) {
            if ("debug".equals(args[1])) {
                level = 0;
            } else if ("verbose".equals(args[1])) {
                level = 1;
            } else if ("normal".equals(args[1])) {
                level = 2;
            }
            System.out.println("LogLevel:" + level + "  <- " + 1);
        }
        DefaultMonitor mon = new DefaultMonitor(level);
        mon.setFormat("%message%");
        int port = Integer.parseInt(args[0]);
        BinServer server = new BinServer(mon, port);
        server.addHandler("echo_int1", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                return new Byte((byte)(((Number)arg[0]).byteValue() * 2));
            }
        });
        server.addHandler("echo_int2", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                return new Short((short)(((Number)arg[0]).shortValue() * 2));
            }
        });
        server.addHandler("echo_int4", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                return new Integer(((Number)arg[0]).intValue() * 2);
            }
        });
        server.addHandler("echo_int8", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                return new Long(((Number)arg[0]).longValue() * 2L);
            }
        });
        server.addHandler("echo_str", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                String s = (String)arg[0];
                return s + s;
            }
        });
        server.addHandler("echo_decimal", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                BigDecimal s = null;
                s = arg[0] instanceof BigDecimal ? (BigDecimal)arg[0] : new BigDecimal(arg[0].toString());
                return s.multiply(new BigDecimal("2"));
            }
        });
        server.addHandler("echo_float", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                return new Float(((Number)arg[0]).floatValue() * 2.0f);
            }
        });
        server.addHandler("echo_double", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                return new Double(((Number)arg[0]).doubleValue() * 2.0);
            }
        });
        server.addHandler("echo_int1_array", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                byte[] ba = (byte[])arg[0];
                int i = 0;
                while (i < ba.length) {
                    int n = i++;
                    ba[n] = (byte)(ba[n] * 2);
                }
                return ba;
            }
        });
        server.addHandler("echo_int4_array", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                int[] ba = (int[])arg[0];
                int i = 0;
                while (i < ba.length) {
                    int n = i++;
                    ba[n] = ba[n] * 2;
                }
                return ba;
            }
        });
        server.addHandler("echo_str_array", new IMessageHandler(){

            public Object send(Object[] arg) throws Exception {
                String[] ba = (String[])arg[0];
                for (int i = 0; i < ba.length; ++i) {
                    ba[i] = ba[i] + ba[i];
                }
                return ba;
            }
        });
        final boolean[] stopper = new boolean[]{false};
        server.addHandler("exit", new IMessageHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object send(Object[] arg) throws Exception {
                boolean[] blArray = stopper;
                synchronized (stopper) {
                    stopper[0] = true;
                    stopper.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            }
        });
        server.start();
        System.out.println("Server started on port[" + port + "]. Send [exit] message to shutdown this server.");
        while (true) {
            boolean[] blArray = stopper;
            // MONITORENTER : stopper
            if (stopper[0]) {
                Thread.sleep(300L);
                server.shutdown();
                Thread.sleep(300L);
                System.exit(0);
            }
            stopper.wait();
            // MONITOREXIT : blArray
        }
    }
}

