/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.binstream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.LinkedList;
import jbridge.InvocationPool;
import jbridge.Utils;
import jbridge.comm.binstream.AbstractResultObject;
import jbridge.comm.binstream.AbstractTransferObject;
import jbridge.comm.binstream.BinConstants;
import jbridge.comm.binstream.BinDecoder;
import jbridge.comm.binstream.BinStreamException;
import jbridge.comm.binstream.CallingObject;
import jbridge.comm.binstream.DecodeHandlerClass;
import jbridge.comm.binstream.IMessageHandler;
import jbridge.comm.binstream.ResultErrObject;
import jbridge.comm.binstream.ResultOkObject;
import jbridge.comm.binstream.ServiceManager;
import jp.gr.java_conf.ccs2.core.MessageMonitor;

public class MessageServer
implements BinConstants {
    private MessageMonitor monitor;
    private String name;
    private ServiceManager handlerTable;
    private String salt = Long.toString((long)(Math.random() * (double)System.currentTimeMillis()));
    private long sidCounter = 0L;
    private Object sidLock = new Integer(1);
    private Object sendingLock = new Integer(2);
    private LinkedList sendingQueue = new LinkedList();
    private LinkedList waitingList = new LinkedList();
    private Object receivingLock = new Integer(3);
    private HashMap receivingTable = new HashMap();
    private Thread socketThread;
    private Thread sendingThread;
    private Thread receivingThread;
    private InvocationPool invocationPool;
    public static final int SOCKET_NOT_CONNECTED = 0;
    public static final int SOCKET_CLOSING = 1;
    public static final int SOCKET_OPENED = 2;
    private Object socketLock = new Integer(3);
    private int socketState = 0;
    private Socket socket;
    private long lastErrorTime = -1L;
    private int fatalErrorCount = 0;
    private static final long FATAL_ERROR_CONTINUETIME = 500L;
    private static final long FATAL_ERROR_STOPCOUNT = 5L;
    private OutputStream out;
    private InputStream in;
    private Runnable sender = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                MessageServer.this.sendingLoop();
                Object var2_1 = null;
                MessageServer.this.monitor.verbose("MS: Sender-thread finished.");
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                MessageServer.this.monitor.verbose("MS: Sender-thread finished.");
                MessageServer.this.sendingThread = null;
                Object object = MessageServer.this.socketLock;
                synchronized (object) {
                    MessageServer.this.socketLock.notifyAll();
                }
                throw throwable;
            }
            MessageServer.this.sendingThread = null;
            Object object = MessageServer.this.socketLock;
            synchronized (object) {
                MessageServer.this.socketLock.notifyAll();
            }
        }
    };
    private Runnable receiver = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                MessageServer.this.receivingLoop();
                Object var2_1 = null;
                MessageServer.this.monitor.debug("MS: Receive-thread finished.");
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                MessageServer.this.monitor.debug("MS: Receive-thread finished.");
                MessageServer.this.receivingThread = null;
                Object object = MessageServer.this.socketLock;
                synchronized (object) {
                    MessageServer.this.socketLock.notifyAll();
                }
                throw throwable;
            }
            MessageServer.this.receivingThread = null;
            Object object = MessageServer.this.socketLock;
            synchronized (object) {
                MessageServer.this.socketLock.notifyAll();
            }
        }
    };

    public MessageServer(String name, MessageMonitor mon, ServiceManager sm) {
        this.name = name;
        this.monitor = mon;
        this.handlerTable = sm;
        this.invocationPool = new InvocationPool(this.monitor, 4, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSocket(Socket s) throws IOException {
        Object object = this.socketLock;
        synchronized (object) {
            if (this.socketState != 0) {
                throw new RuntimeException("Wrong socket state: " + this.socketState);
            }
            this.socket = s;
            this.in = new BufferedInputStream(this.socket.getInputStream(), 8192);
            this.out = new BufferedOutputStream(this.socket.getOutputStream(), 8192);
            this.socketState = 2;
            this.monitor.debug("MS:ready for I/O stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockWorkingThread() {
        if (this.socketState != 2) {
            return;
        }
        this.monitor.debug("MS:started working block.");
        Object object = this.socketLock;
        synchronized (object) {
            this.receivingThread = new Thread(this.receiver);
            this.receivingThread.setName(this.name + "|receiving");
            this.receivingThread.start();
            this.sendingThread = new Thread(this.sender);
            this.sendingThread.setName(this.name + "|sending");
            this.sendingThread.start();
        }
        while (true) {
            object = this.socketLock;
            synchronized (object) {
                if (this.sendingThread == null) {
                    break;
                }
                try {
                    this.socketLock.wait(500L);
                }
                catch (InterruptedException e) {
                    this.monitor.recordStackTrace(e);
                    break;
                }
            }
        }
        this.monitor.debug("MS:closing socket.");
        object = this.socketLock;
        synchronized (object) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.monitor.recordStackTrace(e);
            }
            this.socketState = 0;
            this.socketLock.notifyAll();
        }
        this.monitor.debug("MS:finished working block.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.monitor.debug("MS:shutdown message arived.");
        Object object = this.socketLock;
        synchronized (object) {
            if (this.socketState == 0) {
                this.monitor.debug("MS:shutdown: not connecting state: " + this.socketState);
                return;
            }
            this.socketState = 1;
            Object object2 = this.sendingLock;
            synchronized (object2) {
                this.sendingLock.notifyAll();
            }
        }
        while (true) {
            object = this.socketLock;
            synchronized (object) {
                if (this.socketState == 0) {
                    break;
                }
                try {
                    this.socketLock.wait(500L);
                }
                catch (InterruptedException e) {
                    this.monitor.recordStackTrace(e);
                }
            }
        }
        if (this.sendingQueue.size() > 0) {
            this.monitor.debug("MS: " + this.sendingQueue.size() + " messages are remained.");
        }
        this.monitor.debug("MS:shutdowned.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSID() {
        Object object = this.sidLock;
        synchronized (object) {
            ++this.sidCounter;
            return "SB:" + this.salt + ":" + this.sidCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object send(String name, Object[] args) throws IOException {
        Object object;
        Object object2;
        Object sid = null;
        Object object3 = this.sendingLock;
        synchronized (object3) {
            sid = this.addCallingMessageToSendingQueue(name, args);
            this.waitingList.add(sid);
            this.sendingLock.notifyAll();
        }
        try {
            while (true) {
                object3 = this.receivingLock;
                synchronized (object3) {
                    AbstractResultObject ret = (AbstractResultObject)this.receivingTable.get(sid);
                    if (ret != null) {
                        object2 = ret.getValue();
                        // MONITOREXIT @DISABLED, blocks:[1, 8, 14, 15] lbl16 : MonitorExitStatement: MONITOREXIT : var4_4
                        Object var10_8 = null;
                        object = this.sendingLock;
                        break;
                    }
                }
                object3 = this.receivingLock;
                synchronized (object3) {
                    try {
                        this.receivingLock.wait(500L);
                    }
                    catch (InterruptedException e) {
                        this.monitor.recordStackTrace(e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Object object4 = this.sendingLock;
            synchronized (object4) {
                this.waitingList.remove(sid);
                throw throwable;
            }
        }
        synchronized (object) {
            this.waitingList.remove(sid);
            return object2;
        }
    }

    private Object addResultToSendingQueue(Object sid, Object obj) {
        ResultOkObject r = new ResultOkObject(sid, obj);
        this.sendingQueue.add(r);
        this.monitor.debug("MS: +Queue[" + this.sendingQueue.size() + "] : " + r);
        return sid;
    }

    private Object addErrorToSendingQueue(Object sid, int code, String klass, String message, String detail) {
        ResultErrObject c = new ResultErrObject(sid, code, klass, message, detail);
        this.sendingQueue.add(c);
        this.monitor.debug("MS: +Queue[" + this.sendingQueue.size() + "] : " + c);
        return sid;
    }

    private Object addCallingMessageToSendingQueue(String name, Object[] args) {
        Object sid = this.getSID();
        CallingObject c = new CallingObject(sid, name, args);
        this.sendingQueue.add(c);
        this.monitor.debug("MS: +Queue[" + this.sendingQueue.size() + "] : " + c);
        return sid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendingLoop() {
        while (true) {
            Object object;
            Object sw;
            Object object2;
            AbstractTransferObject entry = null;
            try {
                object2 = this.sendingLock;
                synchronized (object2) {
                    if (this.sendingQueue.size() > 0) {
                        entry = (AbstractTransferObject)this.sendingQueue.removeFirst();
                        this.monitor.debug("MS: -Queue[" + this.sendingQueue.size() + "] : " + entry.sid);
                        entry.exec(this.out);
                        this.monitor.debug("MS:  sent a message : " + entry.sid);
                    }
                }
            }
            catch (BinStreamException e) {
                this.monitor.recordStackTrace(e);
                if (entry == null) continue;
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)sw));
                ((StringWriter)sw).flush();
                object = this.sendingLock;
                synchronized (object) {
                    this.addErrorToSendingQueue(entry.sid, 33, "BinStreamException", e.getMessage() + " (maybe bug...)", ((StringWriter)sw).toString());
                    this.sendingLock.notifyAll();
                    continue;
                }
            }
            catch (IOException e) {
                if (entry != null) {
                    this.monitor.warning("Failed to sending the message: " + entry);
                    sw = this.sendingLock;
                    synchronized (sw) {
                        this.sendingQueue.add(entry);
                    }
                }
                String mes = e.getMessage();
                if (e instanceof SocketException && mes != null && (mes.toLowerCase().indexOf("abort") >= 0 || mes.toLowerCase().indexOf("broken") >= 0)) {
                    this.monitor.verbose("MS: [sendloop] disconnected by remote host.");
                    object = this.socketLock;
                    synchronized (object) {
                        this.socketState = 1;
                        break;
                    }
                }
                if (this.isRecoverableException(e)) {
                    this.monitor.debug("MS: [sendloop] going to recover the communication.");
                    continue;
                }
                this.monitor.recordStackTrace(e);
                this.monitor.verbose("MS: [sendloop] try to reset the connection.");
                object = this.socketLock;
                synchronized (object) {
                    this.socketState = 1;
                    break;
                }
            }
            catch (RuntimeException e) {
                this.monitor.recordStackTrace(e);
                this.monitor.verbose("MS: [sendloop] going to recover the communication.");
                continue;
            }
            object2 = this.socketLock;
            synchronized (object2) {
                if (this.socketState == 1) {
                    this.monitor.debug("MS: sender-thread terminating...");
                    return;
                }
            }
            object2 = this.sendingLock;
            synchronized (object2) {
                if (this.sendingQueue.size() > 0) {
                    continue;
                }
                try {
                    this.sendingLock.wait(500L);
                }
                catch (InterruptedException e) {
                    this.monitor.recordStackTrace(e);
                    break;
                }
            }
        }
    }

    private ByteArrayInputStream readMessage(InputStream in, int size) throws IOException {
        int len;
        byte[] array = new byte[size];
        for (int pos = 0; pos < size; pos += len) {
            len = in.read(array, pos, size - pos);
        }
        return new ByteArrayInputStream(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receivingLoop() {
        final byte[] mcode = new byte[]{-1};
        final int[] msize = new int[]{0};
        DecodeHandlerClass mcodeHandler = new DecodeHandlerClass(){

            public void readByte(byte a) {
                mcode[0] = a;
            }

            public void readInt(int a) {
                msize[0] = a;
            }
        };
        while (true) {
            try {
                while (true) {
                    Object ret;
                    mcode[0] = -1;
                    BinDecoder.read(this.in, mcodeHandler);
                    BinDecoder.read(this.in, mcodeHandler);
                    this.monitor.debug("MS: receiving a message : code=" + mcode[0] + " size=" + msize[0]);
                    if (mcode[0] == 0) {
                        CallingObject c = CallingObject.getCallingObject(this.readMessage(this.in, msize[0]));
                        this.monitor.debug("MS: received: " + c);
                        this.received(c);
                    } else {
                        if (mcode[0] != 1) {
                            if (mcode[0] != -1) throw new RuntimeException("Wrong method code: " + mcode[0]);
                            this.monitor.verbose("MS: disconnected by remote host.");
                            ret = this.socketLock;
                            synchronized (ret) {
                                this.socketState = 1;
                            }
                            ret = this.sendingLock;
                            synchronized (ret) {
                                this.sendingLock.notifyAll();
                                return;
                            }
                        }
                        ret = AbstractResultObject.get(this.readMessage(this.in, msize[0]));
                        this.monitor.debug("MS: received: " + ret);
                        Object object = this.receivingLock;
                        synchronized (object) {
                            this.receivingTable.put(((AbstractResultObject)ret).sid, ret);
                            this.receivingLock.notifyAll();
                        }
                    }
                    ret = this.socketLock;
                    synchronized (ret) {
                        if (this.socketState == 1) {
                            this.monitor.debug("MS: receiver-thread terminating...");
                            return;
                        }
                    }
                }
            }
            catch (IOException e) {
                String mes = e.getMessage();
                if (e instanceof SocketException && mes != null && (mes.toLowerCase().indexOf("close") >= 0 || mes.toLowerCase().indexOf("broken") >= 0)) {
                    this.monitor.verbose("MS: [rcvloop] disconnected by remote host.");
                    return;
                }
                if (!this.isRecoverableException(e)) {
                    this.monitor.recordStackTrace(e);
                    this.monitor.warning("MS: [rcvloop] try to reset the connection.");
                    Object object = this.socketLock;
                    synchronized (object) {
                        this.socketState = 1;
                        return;
                    }
                }
                this.monitor.warning("MS: [rcvloop] going to recover the communication.");
                continue;
            }
            catch (RuntimeException e) {
                this.monitor.recordStackTrace(e);
                this.monitor.warning("MS: [rcvloop] going to recover the communication.");
                continue;
            }
            break;
        }
    }

    boolean isRecoverableException(IOException e) {
        if (e instanceof EOFException) {
            this.monitor.warning("Connection closed by peer : " + e.getMessage());
            return true;
        }
        if (e instanceof InterruptedIOException) {
            this.monitor.warning("Interrupted by time out : " + e.getMessage());
            return true;
        }
        if (e instanceof ProtocolException || e instanceof SocketException) {
            this.monitor.recordStackTrace(e);
            long corTime = System.currentTimeMillis();
            if (this.lastErrorTime > 0L) {
                if (Math.abs(this.lastErrorTime - corTime) < 500L) {
                    ++this.fatalErrorCount;
                    if ((long)this.fatalErrorCount >= 5L) {
                        return false;
                    }
                } else {
                    this.fatalErrorCount = 0;
                }
            }
            this.lastErrorTime = corTime;
            return true;
        }
        this.monitor.warning("Unrecoverable error occued. [" + e.getClass().getName() + " : " + e.getMessage() + "]");
        this.monitor.recordStackTrace(e);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void received(CallingObject c) {
        IMessageHandler handler = null;
        Object object = this.handlerTable;
        synchronized (object) {
            handler = this.handlerTable.getHandler(c.name);
        }
        if (handler == null) {
            object = this.sendingLock;
            synchronized (object) {
                this.addErrorToSendingQueue(c.sid, 33, "NoSuchRemoteMethodException", "Not found the remote method " + c.name + ".", "");
                this.sendingLock.notifyAll();
            }
            return;
        }
        this.invocationPool.invokes(new MethodInvocation(handler, c));
    }

    private class MethodInvocation
    implements Runnable {
        private IMessageHandler handler;
        private CallingObject callingObj;

        MethodInvocation(IMessageHandler h, CallingObject c) {
            this.handler = h;
            this.callingObj = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Utils.writeArguments(MessageServer.this.monitor, 0, new String[]{"MS:methodInvocation: Start: ", this.callingObj.sid.toString(), "  ", this.callingObj.name}, this.callingObj.args);
            try {
                try {
                    Object ret = this.handler.send(this.callingObj.args);
                    Object object = MessageServer.this.sendingLock;
                    synchronized (object) {
                        MessageServer.this.addResultToSendingQueue(this.callingObj.sid, ret);
                    }
                }
                catch (Exception e) {
                    Throwable t = e;
                    while (true) {
                        if (t.getCause() == null) {
                            MessageServer.this.monitor.debug("Exporting exception : " + t.getClass().getName());
                            Object object = MessageServer.this.sendingLock;
                            synchronized (object) {
                                MessageServer.this.addErrorToSendingQueue(this.callingObj.sid, 34, t.getClass().getName(), t.getMessage(), Utils.trace2str(t));
                            }
                            Object var7_8 = null;
                            Object object2 = MessageServer.this.sendingLock;
                            synchronized (object2) {
                                MessageServer.this.sendingLock.notifyAll();
                            }
                            Utils.writeArray(MessageServer.this.monitor, 0, new Object[]{"MS:methodInvocation: End:", this.callingObj.sid.toString(), "  ", this.callingObj.name});
                            return;
                        }
                        t = t.getCause();
                    }
                }
                catch (Throwable e) {
                    MessageServer.this.monitor.recordStackTrace(e);
                    MessageServer.this.monitor.warning("Handler raise an error: " + e.getClass().getName() + " : " + e.getMessage());
                    Object object4 = MessageServer.this.sendingLock;
                    synchronized (object4) {
                        MessageServer.this.addErrorToSendingQueue(this.callingObj.sid, 35, e.getClass().getName(), e.getMessage(), Utils.trace2str(e));
                    }
                    Object var7_9 = null;
                    Object object = MessageServer.this.sendingLock;
                    synchronized (object) {
                        MessageServer.this.sendingLock.notifyAll();
                    }
                    Utils.writeArray(MessageServer.this.monitor, 0, new Object[]{"MS:methodInvocation: End:", this.callingObj.sid.toString(), "  ", this.callingObj.name});
                    return;
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                Object object3 = MessageServer.this.sendingLock;
                synchronized (object3) {
                    MessageServer.this.sendingLock.notifyAll();
                }
                Utils.writeArray(MessageServer.this.monitor, 0, new Object[]{"MS:methodInvocation: End:", this.callingObj.sid.toString(), "  ", this.callingObj.name});
                throw throwable;
            }
            Object object = MessageServer.this.sendingLock;
            synchronized (object) {
                MessageServer.this.sendingLock.notifyAll();
            }
            Utils.writeArray(MessageServer.this.monitor, 0, new Object[]{"MS:methodInvocation: End:", this.callingObj.sid.toString(), "  ", this.callingObj.name});
        }
    }
}

