/*
 * Decompiled with CFR 0.152.
 */
package jbridge.comm.binstream;

import java.io.IOException;
import java.io.OutputStream;
import jbridge.RemoteRuntimeException;
import jbridge.comm.binstream.AbstractResultObject;
import jbridge.comm.binstream.BinEncoder;
import jbridge.comm.binstream.BinStreamException;

public class ResultErrObject
extends AbstractResultObject {
    private int code;
    private String err_klass;
    private String err_message;
    private String err_detail;

    public ResultErrObject(Object _sid, int c, String k, String m, String d) {
        super(_sid);
        this.code = c;
        this.err_klass = k;
        this.err_message = m;
        this.err_detail = d;
    }

    protected void exec_impl(OutputStream out) throws IOException {
        BinEncoder.writeObject(out, this.sid);
        BinEncoder.write(out, (byte)this.code);
        BinEncoder.write(out, this.err_klass);
        BinEncoder.write(out, this.err_message);
        BinEncoder.write(out, this.err_detail);
        out.flush();
    }

    Object getValue() throws BinStreamException, IOException {
        switch (this.code) {
            case 34: {
                throw new RemoteRuntimeException(this.err_klass, this.err_message, this.err_detail);
            }
            case 33: {
                throw new IOException("Communication error: class=" + this.err_klass + "  message=" + this.err_message + "\n" + this.err_detail);
            }
            case 35: {
                throw new InternalError("Fatal error: class=" + this.err_klass + "  message=" + this.err_message + "\n" + this.err_detail);
            }
        }
        throw new RuntimeException("Unknown return code:" + this.code);
    }

    public String toString() {
        String id = "UNKNOWN";
        switch (this.code) {
            case 34: {
                id = "APP_ERROR";
                break;
            }
            case 33: {
                id = "PROTOCOL_ERROR";
                break;
            }
            case 35: {
                id = "FATAL_ERROR";
            }
        }
        return "ResultErrObject: " + id + " : sid=" + this.sid + "  class=: " + this.err_klass + " [" + this.err_message + "]";
    }
}

